<?php
$max_content_width = get_theme_mod('max_content_width','1200px');
// Logo
$logo_width = get_theme_mod('logo_width','150px');
$m_logo_width = get_theme_mod('m_logo_width','120px');
$s_logo_width = get_theme_mod('s_logo_width','150px');
$foot_logo_width = get_theme_mod('foot_logo_width','150px');

$jl_logo_size = get_theme_mod('jl_logo_size', '33px');
$jl_logo_size_mob = get_theme_mod('jl_logo_size_mob', '30px');
$jl_logo_color = get_theme_mod('jl_logo_color','#000');
$jl_logo_color_dark = get_theme_mod('jl_logo_color_dark','#fff');
$jl_logo_color_side = get_theme_mod('jl_logo_color_side','#000');
$jl_logo_color_side_dark = get_theme_mod('jl_logo_color_side_dark','#fff');
$jl_logo_color_foot = get_theme_mod('jl_logo_color_foot','#fff');
$jl_logo_color_foot_dark = get_theme_mod('jl_logo_color_foot_dark','#fff');


// Header
$section_top_bar_height = get_theme_mod('section_top_bar_height','35px');
$section_logo_height = get_theme_mod('section_logo_height','120px');
$section_menu_height = get_theme_mod('section_menu_height','70px');

//Menu
$wesper_menu_font_family = get_theme_mod('wesper_menu_font_family', 'Inter Tight');
$wesper_menu_font_size = get_theme_mod('wesper_menu_font_size', '16px');
$wesper_menu_font_weight = get_theme_mod('wesper_menu_font_weight', '700');
$wesper_menu_transform = get_theme_mod('wesper_menu_transform', 'capitalize');
$letter_spacing_menu = get_theme_mod('letter_spacing_menu', '0em');
$spacing_menu = get_theme_mod('spacing_menu', '30px');

//Sub Menu
$wesper_sub_menu_font_size = get_theme_mod('wesper_sub_menu_font_size', '14px');
$wesper_sub_menu_font_weight = get_theme_mod('wesper_sub_menu_font_weight', '500');
$sub_menu_transform = get_theme_mod('sub_menu_transform', 'capitalize');
$sub_spacing_menu = get_theme_mod('sub_spacing_menu', '0em');

//Paragraph
$wesper_p_font_family = get_theme_mod('wesper_p_font_family', 'Inter');
$wesper_p_font_size = get_theme_mod('wesper_p_font_size', '15px');
$wesper_p_font_weight = get_theme_mod('wesper_p_font_weight', '400');
$p_line_height = get_theme_mod('p_line_height', '1.5');
$body_font_size = get_theme_mod('body_font_size', '15px');
$body_line_height = get_theme_mod('body_line_height', '1.5');

//Title
$wesper_title_font_family = get_theme_mod('wesper_title_font_family', 'Inter Tight');
$wesper_title_font_weight = get_theme_mod('wesper_title_font_weight', '800');
$wesper_title_transform = get_theme_mod('wesper_title_transform', 'none');
$letter_spacing_heading = get_theme_mod('letter_spacing_heading', '0em');
$line_height_heading = get_theme_mod('line_height_heading', '1.2');

//Catgory, Meta, Button
$wesper_cat_font_size    = get_theme_mod('wesper_cat_font_size', '15px');
$wesper_cat_font_weight = get_theme_mod('wesper_cat_font_weight', '700');
$wesper_cat_transform	= get_theme_mod('wesper_cat_transform', 'capitalize');
$letter_spacing_cat 	= get_theme_mod('letter_spacing_cat', '0em');
$wesper_meta_font_size 	= get_theme_mod('wesper_meta_font_size', '11px');
$wesper_meta_font_weight = get_theme_mod('wesper_meta_font_weight', '400');
$wesper_meta_a_font_weight = get_theme_mod('wesper_meta_a_font_weight', '600');
$wesper_meta_transform     = get_theme_mod('wesper_meta_transform', 'uppercase');
$letter_spacing_meta     = get_theme_mod('letter_spacing_meta', '.04em');

// Button setting
$wesper_button_font_size = get_theme_mod('wesper_button_font_size', '12px');
$wesper_button_font_weight = get_theme_mod('wesper_button_font_weight', '700');
$wesper_button_transform = get_theme_mod('wesper_button_transform', 'uppercase');
$letter_spacing_button = get_theme_mod('letter_spacing_button', '0.1em');
$button_radius = get_theme_mod('button_radius', '4px');

// Load more setting
$wesper_loadmore_font_size = get_theme_mod('wesper_loadmore_font_size', '12px');
$wesper_loadmore_font_weight = get_theme_mod('wesper_loadmore_font_weight', '700');
$wesper_loadmore_transform = get_theme_mod('wesper_loadmore_transform', 'uppercase');
$letter_spacing_loadmore = get_theme_mod('letter_spacing_loadmore', '0.1em');
$load_more_radius = get_theme_mod('load_more_radius', '4px');
$load_more_width = get_theme_mod('load_more_width', '290px');
$load_more_height = get_theme_mod('load_more_height', '48px');

// Other blog
$border_rounded = get_theme_mod('border_rounded', '0px');
$top_border_rounded = get_theme_mod('top_border_rounded', '60px');
$single_title_size = get_theme_mod('single_title_size', '40px');
$wesper_related_size = get_theme_mod('wesper_related_size', '20px');

//cookie
$jl_cookie_dec_size = get_theme_mod('jl_cookie_dec_size', '13px');
$jl_cookie_btn_size = get_theme_mod('jl_cookie_btn_size', '12px');
$jl_cookie_btn_space = get_theme_mod('jl_cookie_btn_space', '0em');
$jl_cookie_btn_tranform = get_theme_mod('jl_cookie_btn_tranform', 'capitalize');

//progress bar
$sp_progress_height = get_theme_mod('sp_progress_height','5px');
$sp_progress_pos = get_theme_mod('sp_progress_pos','top');
$sp_color1 = get_theme_mod('sp_color1','#ff0080');
$sp_color2 = get_theme_mod('sp_color2','#8100ff');

// Theme color
$theme_color = get_theme_mod('theme_color');
if(empty($theme_color)){$theme_color = '#f21717';}

$theme_color_dark = get_theme_mod('theme_color_dark');
if(empty($theme_color_dark)){$theme_color_dark = '#f21717';}

$theme_bg_color = get_theme_mod('theme_bg_color');
if(empty($theme_bg_color)){$theme_bg_color = '#FFF';}

$theme_bg_color_dark = get_theme_mod('theme_bg_color_dark');
if(empty($theme_bg_color_dark)){$theme_bg_color_dark = '#111';}

$theme_text_color = get_theme_mod('theme_text_color');
if(empty($theme_text_color)){$theme_text_color = '#000';}

$theme_text_color_dark = get_theme_mod('theme_text_color_dark');
if(empty($theme_text_color_dark)){$theme_text_color_dark = '#FFF';}

// Menu color
$menu_bg_color = get_theme_mod('menu_bg_color');
if(empty($menu_bg_color)){ $menu_bg_color = '#FFF';}

$menu_bg_color_dark = get_theme_mod('menu_bg_color_dark');
if(empty($menu_bg_color_dark)){ $menu_bg_color_dark = '#111';}

$menu_text_color = get_theme_mod('menu_text_color');
if(empty($menu_text_color)){ $menu_text_color = '#000';}

$menu_text_color_dark = get_theme_mod('menu_text_color_dark');
if(empty($menu_text_color_dark)){ $menu_text_color_dark = '#FFF';}

$submenu_back_color = get_theme_mod('submenu_back_color');
if(empty($submenu_back_color)){ $submenu_back_color = '#f7f7f6';}

$submenu_back_color_dark = get_theme_mod('submenu_back_color_dark');
if(empty($submenu_back_color_dark)){ $submenu_back_color_dark = '#222';}

$submenu_text_color = get_theme_mod('submenu_text_color');
if(empty($submenu_text_color)){ $submenu_text_color = '#000';}

$submenu_text_color_dark = get_theme_mod('submenu_text_color_dark');
if(empty($submenu_text_color_dark)){ $submenu_text_color_dark = '#FFF';}

$menu_line_color = get_theme_mod('menu_line_color');
if(empty($menu_line_color)){ $menu_line_color = '#eeedeb';}

$menu_line_color_dark = get_theme_mod('menu_line_color_dark');
if(empty($menu_line_color_dark)){ $menu_line_color_dark = '#ffffff26';}

$submenu_line_color = get_theme_mod('submenu_line_color');
if(empty($submenu_line_color)){ $submenu_line_color = '#ebebe3';}

$submenu_line_color_dark = get_theme_mod('submenu_line_color_dark');
if(empty($submenu_line_color_dark)){ $submenu_line_color_dark = '#464646';}

// Top menu color
$top_menu_bg_color = get_theme_mod('top_menu_bg_color');
if(empty($top_menu_bg_color)){ $top_menu_bg_color = '#000';}

$top_menu_text_color = get_theme_mod('top_menu_text_color');
if(empty($top_menu_text_color)){ $top_menu_text_color = '#FFF';}

$top_menu_bg_color_dark = get_theme_mod('top_menu_bg_color_dark');
if(empty($top_menu_bg_color_dark)){ $top_menu_bg_color_dark = '#000';}

$top_menu_text_color_dark = get_theme_mod('top_menu_text_color_dark');
if(empty($top_menu_text_color_dark)){ $top_menu_text_color_dark = '#FFF';}

$section_top_bar_height = get_theme_mod('section_top_bar_height','35px');
$section_top_bar_size = get_theme_mod('section_top_bar_size','15px');

// Logo section color
$head_logo_bg_color = get_theme_mod('head_logo_bg_color');
if(empty($head_logo_bg_color)){ $head_logo_bg_color = '#FFF';}

$head_logo_bg_color_dark = get_theme_mod('head_logo_bg_color_dark');
if(empty($head_logo_bg_color_dark)){ $head_logo_bg_color_dark = '#111';}

$head_logo_text_color = get_theme_mod('head_logo_text_color');
if(empty($head_logo_text_color)){ $head_logo_text_color = '#000';}

$head_logo_text_color_dark = get_theme_mod('head_logo_text_color_dark');
if(empty($head_logo_text_color_dark)){ $head_logo_text_color_dark = '#FFF';}

// Single color
$single_color = get_theme_mod('single_color');
if(empty($single_color)){$single_color = '#676767';}

$single_color_dark = get_theme_mod('single_color_dark');
if(empty($single_color_dark)){$single_color_dark = '#FFF';}

$single_link_color = get_theme_mod('single_link_color');
if(empty($single_link_color)){$single_link_color = '#f21717';}

$single_link_color_dark = get_theme_mod('single_link_color_dark');
if(empty($single_link_color_dark)){$single_link_color_dark = '#f21717';}

$single_link_hover_color = get_theme_mod('single_link_hover_color');
if(empty($single_link_hover_color)){$single_link_hover_color = '#f21717';}

$single_link_hover_color_dark = get_theme_mod('single_link_hover_color_dark');
if(empty($single_link_hover_color_dark)){$single_link_hover_color_dark = '#f21717';}

$post_meta_color = get_theme_mod('post_meta_color');
if(empty($post_meta_color)){$post_meta_color = '#0a0a0a';}

$post_meta_color_dark = get_theme_mod('post_meta_color_dark');
if(empty($post_meta_color_dark)){$post_meta_color_dark = '#bbb';}

$post_except_color = get_theme_mod('post_except_color');
if(empty($post_except_color)){$post_except_color = '#666';}

$post_except_color_dark = get_theme_mod('post_except_color_dark');
if(empty($post_except_color_dark)){$post_except_color_dark = '#ddd';}

$post_line_color = get_theme_mod('post_line_color');
if(empty($post_line_color)){$post_line_color = '#dbdbdb';}

$post_line_color_dark = get_theme_mod('post_line_color_dark');
if(empty($post_line_color_dark)){$post_line_color_dark = '#49494b';}

$category_label_padding = get_theme_mod('category_label_padding');
$category_label_radius = get_theme_mod('category_label_radius');

// Footer color
$footer_bg_color = get_theme_mod('footer_bg_color');
if(empty($footer_bg_color)){$footer_bg_color = '#111';}

$footer_bg_dark = get_theme_mod('footer_bg_dark');
if(empty($footer_bg_dark)){$footer_bg_dark = '#000';}

$footer_text_color = get_theme_mod('footer_text_color');
if(empty($footer_text_color)){$footer_text_color = '#a8a8aa';}

$footer_text_dark = get_theme_mod('footer_text_dark');
if(empty($footer_text_dark)){$footer_text_dark = '#a8a8aa';}

$footer_link_color = get_theme_mod('footer_link_color');
if(empty($footer_link_color)){$footer_link_color = '#dcdcdc';}

$footer_link_dark = get_theme_mod('footer_link_dark');
if(empty($footer_link_dark)){$footer_link_dark = '#dcdcdc';}

$footer_link_hcolor = get_theme_mod('footer_link_hcolor');
if(empty($footer_link_hcolor)){$footer_link_hcolor = '#f21717';}

$footer_link_hdark = get_theme_mod('footer_link_hdark');
if(empty($footer_link_hdark)){$footer_link_hdark = '#f21717';}

$footer_head_color = get_theme_mod('footer_head_color');
if(empty($footer_head_color)){$footer_head_color = '#FFF';}

$footer_head_color_dark = get_theme_mod('footer_head_color_dark');
if(empty($footer_head_color_dark)){$footer_head_color_dark = '#FFF';}

$footer_line_color = get_theme_mod('footer_line_color');
if(empty($footer_line_color)){$footer_line_color = '#49494b';}

$footer_line_color_dark = get_theme_mod('footer_line_color_dark');
if(empty($footer_line_color_dark)){$footer_line_color_dark = '#49494b';}

$footer_menu_col = get_theme_mod('footer_menu_col', '1');
$footer_title_size = get_theme_mod('footer_title_size', '18px');
$footer_font_size = get_theme_mod('footer_font_size', '15px');
$footer_copyright_size = get_theme_mod('footer_copyright_size', '14px');
$footer_menu_size = get_theme_mod('footer_menu_size', '14px');

// Widget
$wesper_widget_font_size = get_theme_mod('wesper_widget_font_size', '18px');
$wesper_widget_letter_spacing = get_theme_mod('wesper_widget_letter_spacing', '0em');
$wesper_widget_transform = get_theme_mod('wesper_widget_transform', 'uppercase');

?>
body.options_dark_skin{
    --jl-logo-txt-color: <?php echo esc_attr($jl_logo_color_dark);?>;
    --jl-logo-txt-side-color: <?php echo esc_attr($jl_logo_color_side_dark);?>;
    --jl-logo-txt-foot-color: <?php echo esc_attr($jl_logo_color_foot_dark);?>;

    --jl-main-color: <?php echo esc_attr($theme_color_dark);?>;
    --jl-bg-color: <?php echo esc_attr($theme_bg_color_dark);?>;
    --jl-txt-color: <?php echo esc_attr($theme_text_color_dark);?>;
    --jl-btn-bg: #454545;
    --jl-comment-btn-link: #454545;
    --jl-comment-btn-linkc: #FFF;
    
    --jl-menu-bg: <?php echo esc_attr($menu_bg_color_dark);?>;
    --jl-menu-line-color: <?php echo esc_attr($menu_line_color_dark);?>;
    --jl-menu-color: <?php echo esc_attr($menu_text_color_dark);?>;
    --jl-sub-bg-color: <?php echo esc_attr($submenu_back_color_dark);?>;
    --jl-sub-menu-color: <?php echo esc_attr($submenu_text_color_dark);?>;
    --jl-sub-line-color: <?php echo esc_attr($submenu_line_color_dark);?>;
    --jl-topbar-bg: <?php echo esc_attr($top_menu_bg_color_dark);?>;
    --jl-topbar-color: <?php echo esc_attr($top_menu_text_color_dark);?>;
    --jl-logo-bg: <?php echo esc_attr($head_logo_bg_color_dark);?>;
    --jl-logo-color: <?php echo esc_attr($head_logo_text_color_dark);?>;

    --jl-single-color: <?php echo esc_attr($single_color_dark);?>;
    --jl-single-link-color: <?php echo esc_attr($single_link_color_dark);?>;
    --jl-single-link-hcolor: <?php echo esc_attr($single_link_hover_color_dark);?>;
    --jl-except-color: <?php echo esc_attr($post_except_color_dark);?>;
    --jl-meta-color: <?php echo esc_attr($post_except_color_dark);?>;
    --jl-post-line-color: <?php echo esc_attr($post_line_color_dark);?>;
    --jl-author-bg: #454545;

    --jl-foot-bg: <?php echo esc_attr($footer_bg_dark);?>;
    --jl-foot-color: <?php echo esc_attr($footer_text_dark);?>;
    --jl-foot-link: <?php echo esc_attr($footer_link_dark);?>;
    --jl-foot-hlink: <?php echo esc_attr($footer_link_hdark);?>;
    --jl-foot-head: <?php echo esc_attr($footer_head_color_dark);?>;
    --jl-foot-line: <?php echo esc_attr($footer_line_color_dark);?>;

}
body{    
    --jl-logo-size: <?php echo esc_attr($jl_logo_size);?>;
    --jl-logo-size-mob: <?php echo esc_attr($jl_logo_size_mob);?>;    
    --jl-logo-txt-color: <?php echo esc_attr($jl_logo_color);?>;    
    --jl-logo-txt-side-color: <?php echo esc_attr($jl_logo_color_side);?>;    
    --jl-logo-txt-foot-color: <?php echo esc_attr($jl_logo_color_foot);?>;    

    --jl-main-width: <?php echo esc_attr($max_content_width);?>;
    --jl-main-color: <?php echo esc_attr($theme_color);?>;
    --jl-bg-color: <?php echo esc_attr($theme_bg_color);?>;
    --jl-txt-color: <?php echo esc_attr($theme_text_color);?>;
    --jl-txt-light: <?php echo esc_attr($theme_text_color_dark);?>;
    --jl-btn-bg: #000;
    --jl-comment-btn-link: #F1F1F1;
    --jl-comment-btn-linkc: #000;
    --jl-desc-light: <?php echo esc_attr($post_except_color_dark);?>;
    --jl-meta-light: <?php echo esc_attr($post_meta_color_dark);?>;

    --jl-button-radius: <?php echo esc_attr($button_radius);?>;
    --jl-load-more-radius: <?php echo esc_attr($load_more_radius);?>;
    --jl-load-more-width: <?php echo esc_attr($load_more_width);?>;
    --jl-load-more-height: <?php echo esc_attr($load_more_height);?>;    

    --jl-menu-bg: <?php echo esc_attr($menu_bg_color);?>;
    --jl-menu-line-color: <?php echo esc_attr($menu_line_color);?>;
    --jl-menu-color: <?php echo esc_attr($menu_text_color);?>;
    --jl-sub-bg-color: <?php echo esc_attr($submenu_back_color);?>;
    --jl-sub-menu-color: <?php echo esc_attr($submenu_text_color);?>;
    --jl-sub-line-color: <?php echo esc_attr($submenu_line_color);?>;

    --jl-topbar-bg: <?php echo esc_attr($top_menu_bg_color);?>;
    --jl-topbar-color: <?php echo esc_attr($top_menu_text_color);?>;
    --jl-topbar-height: <?php echo esc_attr($section_top_bar_height);?>;
    --jl-topbar-size: <?php echo esc_attr($section_top_bar_size);?>;

    --jl-logo-bg: <?php echo esc_attr($head_logo_bg_color);?>;
    --jl-logo-color: <?php echo esc_attr($head_logo_text_color);?>;

    --jl-single-title-size: <?php echo esc_attr($single_title_size);?>;
    --jl-single-color: <?php echo esc_attr($single_color);?>;
    --jl-single-link-color: <?php echo esc_attr($single_link_color);?>;
    --jl-single-link-hcolor: <?php echo esc_attr($single_link_hover_color);?>;
    --jl-except-color: <?php echo esc_attr($post_except_color);?>;
    --jl-meta-color: <?php echo esc_attr($post_meta_color);?>;
    --jl-post-line-color: <?php echo esc_attr($post_line_color);?>;
    --jl-author-bg: #f8f7f5;
    --jl-post-related-size: <?php echo esc_attr($wesper_related_size);?>;

    --jl-foot-bg: <?php echo esc_attr($footer_bg_color);?>;
    --jl-foot-color: <?php echo esc_attr($footer_text_color);?>;
    --jl-foot-link: <?php echo esc_attr($footer_link_color);?>;
    --jl-foot-hlink: <?php echo esc_attr($footer_link_hcolor);?>;
    --jl-foot-head: <?php echo esc_attr($footer_head_color);?>;
    --jl-foot-line: <?php echo esc_attr($footer_line_color);?>;    
    --jl-foot-menu-col: <?php echo esc_attr($footer_menu_col);?>;    
    --jl-foot-title-size: <?php echo esc_attr($footer_title_size);?>;        
    --jl-foot-font-size: <?php echo esc_attr($footer_font_size);?>;        
    --jl-foot-copyright: <?php echo esc_attr($footer_copyright_size);?>;        
    --jl-foot-menu-size: <?php echo esc_attr($footer_menu_size);?>;        

    --jl-body-font: <?php echo esc_attr($wesper_p_font_family);?>;
    --jl-body-font-size: <?php echo esc_attr($body_font_size);?>;
    --jl-body-font-weight: <?php echo esc_attr($wesper_p_font_weight);?>;
    --jl-body-line-height: <?php echo esc_attr($body_line_height);?>;
    --jl-logo-width: <?php echo esc_attr($logo_width);?>;
    --jl-m-logo-width: <?php echo esc_attr($m_logo_width);?>;
    --jl-s-logo-width: <?php echo esc_attr($s_logo_width);?>;
    --jl-fot-logo-width: <?php echo esc_attr($foot_logo_width);?>;
    --jl-title-font: <?php echo esc_attr($wesper_title_font_family);?>;
    --jl-title-font-weight: <?php echo esc_attr($wesper_title_font_weight);?>;
    --jl-title-transform: <?php echo esc_attr($wesper_title_transform);?>;
    --jl-title-space: <?php echo esc_attr($letter_spacing_heading);?>;
    --jl-title-line-height: <?php echo esc_attr($line_height_heading);?>;
    --jl-content-font-size: <?php echo esc_attr($wesper_p_font_size);?>;
    --jl-content-line-height: <?php echo esc_attr($p_line_height);?>;
    --jl-sec-topbar-height: <?php echo esc_attr($section_top_bar_height);?>;
    --jl-sec-menu-height: <?php echo esc_attr($section_menu_height);?>;
    --jl-sec-logo-height: <?php echo esc_attr($section_logo_height);?>;
    --jl-menu-font: <?php echo esc_attr($wesper_menu_font_family);?>;
    --jl-menu-font-size: <?php echo esc_attr($wesper_menu_font_size);?>;
    --jl-menu-font-weight: <?php echo esc_attr($wesper_menu_font_weight);?>;
    --jl-menu-transform: <?php echo esc_attr($wesper_menu_transform);?>;
    --jl-menu-space: <?php echo esc_attr($letter_spacing_menu);?>;
    --jl-spacing-menu: <?php echo esc_attr($spacing_menu);?>;
    --jl-submenu-font-size: <?php echo esc_attr($wesper_sub_menu_font_size);?>;
    --jl-submenu-font-weight: <?php echo esc_attr($wesper_sub_menu_font_weight);?>;
    --jl-submenu-transform: <?php echo esc_attr($sub_menu_transform);?>;
    --jl-submenu-space: <?php echo esc_attr($sub_spacing_menu);?>;
    --jl-cat-font-size: <?php echo esc_attr($wesper_cat_font_size);?>;
    --jl-cat-font-weight: <?php echo esc_attr($wesper_cat_font_weight);?>;
    --jl-cat-font-space: <?php echo esc_attr($letter_spacing_cat);?>;
    --jl-cat-transform: <?php echo esc_attr($wesper_cat_transform);?>;
    --jl-meta-font-size: <?php echo esc_attr($wesper_meta_font_size);?>;
    --jl-meta-font-weight: <?php echo esc_attr($wesper_meta_font_weight);?>;
    --jl-meta-a-font-weight: <?php echo esc_attr($wesper_meta_a_font_weight);?>;
    --jl-meta-font-space: <?php echo esc_attr($letter_spacing_meta);?>;
    --jl-meta-transform: <?php echo esc_attr($wesper_meta_transform);?>;
    --jl-button-font-size: <?php echo esc_attr($wesper_button_font_size);?>;
    --jl-button-font-weight: <?php echo esc_attr($wesper_button_font_weight);?>;
    --jl-button-transform: <?php echo esc_attr($wesper_button_transform);?>;
    --jl-button-space: <?php echo esc_attr($letter_spacing_button);?>;
    --jl-loadmore-font-size: <?php echo esc_attr($wesper_loadmore_font_size);?>;
    --jl-loadmore-font-weight: <?php echo esc_attr($wesper_loadmore_font_weight);?>;
    --jl-loadmore-transform: <?php echo esc_attr($wesper_loadmore_transform);?>;
    --jl-loadmore-space: <?php echo esc_attr($letter_spacing_loadmore);?>;
    --jl-border-rounded: <?php echo esc_attr($border_rounded);?>;
    --jl-top-rounded: <?php echo esc_attr($top_border_rounded);?>;
    --jl-cookie-des-size: <?php echo esc_attr($jl_cookie_dec_size);?>;
    --jl-cookie-btn-size: <?php echo esc_attr($jl_cookie_btn_size);?>;
    --jl-cookie-btn-space: <?php echo esc_attr($jl_cookie_btn_space);?>;
    --jl-cookie-btn-transform: <?php echo esc_attr($jl_cookie_btn_tranform);?>;

    --jl-widget-fsize: <?php echo esc_attr($wesper_widget_font_size);?>;
    --jl-widget-space: <?php echo esc_attr($wesper_widget_letter_spacing);?>;
    --jl-widget-transform: <?php echo esc_attr($wesper_widget_transform);?>;    
}
<?php
if(function_exists('wesper_e_template')){
$jl_cus_font = $wesper_menu_font_family.','.$wesper_p_font_family.','.$wesper_title_font_family;
$jl_cus_font_arr = explode( ',', $jl_cus_font );
$jl_cus_font_unique = array_unique($jl_cus_font_arr);
    if (strpos($jl_cus_font, 'jl_c_') !== false) {
        $fonts = wesper_font_tax::wesper_get_fonts();
        foreach ( $fonts as $font => $values ){
            foreach ($jl_cus_font_unique as $font_text) {
                 if($font_text == 'jl_c_'.$font ){
                ?>
                @font-face {
                  font-family: '<?php echo esc_attr('jl_c_'.$font);?>';
                  <?php if(!empty($values['font_eot-0'])){?>
                  src: url('<?php echo esc_url($values['font_eot-0']);?>');
                  <?php }?>
                  src:<?php if(!empty($values['font_eot-0'])){?> url('<?php echo esc_url($values['font_eot-0']);?>?#iefix') format('embedded-opentype'),
                       <?php }
                       if(!empty($values['font_woff_2-0'])){?>
                       url('<?php echo esc_url($values['font_woff_2-0']);?>') format('woff2'),
                       <?php }
                       if(!empty($values['font_woff-0'])){?>
                       url('<?php echo esc_url($values['font_woff-0']);?>') format('woff'),
                       <?php }
                       if(!empty($values['font_ttf-0'])){?>
                       url('<?php echo esc_url($values['font_ttf-0']);?>')  format('truetype'),
                       <?php }
                       if(!empty($values['font_svg-0'])){?>
                       url('<?php echo esc_url($values['font_svg-0']);?>#<?php echo esc_attr('jl_c_'.$font);?>') format('svg');
                       <?php }?>
                }
                <?php
                }
            }
        }
    }
}?>
<?php
$remove_hzoom_img = get_theme_mod('remove_hzoom_img');
if(!empty($remove_hzoom_img)){echo '.jl_imgw:hover .jl_imgin img, .jl_ov_el:hover .jl_imgin img, .jl_box_info:hover .jl_box_bg img{transform: scale(1.01);}';}
?>
.jlac_smseah.active_search_box{
    overflow: unset;
}
.jlac_smseah.active_search_box .search_header_wrapper .jli-search:before{
    font-family: "jl_font" !important;
    content: "\e906" !important;
}
.jl_shwp{
    display: flex;
    height: 100%;
}
.search_header_wrapper.search_form_menu_personal_click{
    position: relative;
}
.jl_ajse{
    position: absolute !important;
    background: var(--jl-sub-bg-color);
    width: 350px;
    top: 100% !important;
    right: 0px;
    left: auto;
    padding: 10px 25px;
    height: unset;
    box-shadow: 0px 32px 64px -16px rgb(0 0 0 / 16%);
}
.jl_ajse .searchform_theme{    
    padding: 0px;
    float: none !important;
    position: unset;
    transform: unset;
    display: flex;
    align-items: center;
    justify-content: space-between;
}
.jl_ajse .jl_search_head{
    display: flex;
    flex-direction: column;
}
.jl_ajse.search_form_menu_personal .searchform_theme .search_btn{
    float: none;
    border: 0px !important;
    height: 30px;
    font-size: 14px;
    color: var(--jl-sub-menu-color) !important;
}
.jl_ajse .jl_shnone{
    font-size: 14px;
    margin: 0px;
}
.jl_ajse.search_form_menu_personal .searchform_theme .search_btn::-webkit-input-placeholder{
    color: var(--jl-sub-menu-color) !important;
}
.jl_ajse.search_form_menu_personal .searchform_theme .search_btn::-moz-placeholder{
    color: var(--jl-sub-menu-color) !important;
}
.jl_ajse.search_form_menu_personal .searchform_theme .search_btn:-ms-input-placeholder{
    color: var(--jl-sub-menu-color) !important;
}
.jl_ajse.search_form_menu_personal .searchform_theme .search_btn:-moz-placeholder{
    color: var(--jl-sub-menu-color) !important;
}
.jl_ajse .searchform_theme .button{
    height: 30px;
    position: unset;
    padding: 0px 5px !important;
    width: auto;
}
.jlc-hmain-w.jl_base_menu .jl_ajse .searchform_theme .button i.jli-search,
.jlc-stick-main-w .jl_ajse .searchform_theme .button i.jli-search{
    color: var(--jl-sub-menu-color) !important;
    font-size: 14px;
}
.jl_ajse .jl_search_wrap_li{
    --jl-img-space: 10px;
    --jl-img-w: 100px;
    --jl-img-h: 80px;
    --jl-h-align: left;
    --jl-t-size: 14px;
    --jl-txt-color: var(--jl-sub-menu-color) !important;
    --jl-meta-color: var(--jl-sub-menu-color) !important;
    --jlrow-gap: 15px;
    --jl-post-line-color: transparent;
}
.jl_ajse .jl_search_wrap_li .jl-donut-front{
    top: 0px;
    right: 0px;
}
.jl_ajse .jl_search_wrap_li .jl_grid_wrap_f{
    width: 100%;
    display: grid;
    overflow: hidden;
    grid-template-columns: repeat(1,minmax(0,1fr));
    grid-row-gap: var(--jlrow-gap);
    border-top: 1px solid var(--jl-sub-line-color);
    padding-top: 20px;
    margin-top: 10px;
    margin-bottom: 15px;
}
.jl_ajse .jl_post_meta{
    opacity: .5;
    font-size: 10px;
}
.jl_ajse .jl_post_meta .jl_author_img_w, .jl_ajse .jl_post_meta .post-date:before{
    display: none;
}
.jl_item_bread i{font-size: inherit;}
.logo_link, .logo_link:hover{
    font-family: var(--jl-title-font);
    font-weight: var(--jl-title-font-weight);
    text-transform: var(--jl-title-transform);
    letter-spacing: var(--jl-title-space);
    line-height: var(--jl-title-line-height);
    font-size: var(--jl-logo-size);
    color: var(--jl-logo-txt-color);
}
@media only screen and (max-width: 767px) {
    .logo_link, .logo_link:hover{
        font-size: var(--jl-logo-size-mob);
    }
}
.logo_link > h1, .logo_link > span{
    font-size: inherit;
    color: var(--jl-logo-txt-color);
}
.jl_mobile_nav_inner .logo_link, .jl_mobile_nav_inner .logo_link:hover{
    color: var(--jl-logo-txt-side-color);
}
.jl_ft_cw .logo_link, .jl_ft_cw .logo_link:hover{
    color: var(--jl-logo-txt-foot-color);
}
.jl_content p{
    font-size: var(--jl-content-font-size);
    line-height: var(--jl-content-line-height);
}
<?php 
$disable_post_share = get_post_meta( get_the_ID(), 'disable_post_share', true );
$disable_post_share_opt = get_theme_mod('disable_post_share');
if($disable_post_share != 'on'){
    if(empty($disable_post_share_opt)){
        $jl_share = 'show';
    }else{
        $jl_share = 'hide';
    }
}else{
    if(empty($disable_post_share)){
        $jl_share = 'show';
    }else{
        $jl_share = 'hide';
    }
}
if($jl_share == 'hide'){?>
.post_sw{display: none;}
.jls_con_w{max-width: 100%;}    
<?php }?>
<?php if(empty(get_theme_mod('show_classic_social'))){?>
.jl_pl_fs{ display: none;}
<?php }else{?>
.jl_pl_fs{display: flex;}
<?php }?>
<?php if( get_theme_mod('mega_menu_layout') == 'mega_boxed' ){?>
    .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu{
        background: transparent;
        box-shadow: unset;
    }
    .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu .jl_mega_inner{
    max-width: calc(var(--jl-main-width) - 40px);
    padding: 0px 30px;
    box-shadow: 0px 32px 64px -16px rgb(0 0 0 / 16%);
    background: var(--jl-sub-bg-color);
}
<?php }?>
<?php if( get_theme_mod('sticky_header') == 'jl_sticky_fixed' ){?>
    .jl_nav_stick.menu-invisible.menu-detached .jl_r_menu{
        -moz-transform: translateY(0%);
        -ms-transform: translateY(0%);
        -webkit-transform: translateY(0%);
        transform: translateY(0%);
    }
    .jl_sticky_fixed .jl-sb-w .jl-sb-in, .jl_sticky_fixed .jl-sticky > *, .menu-detached .jl_sidebar_w, .jl_sticky_fixed .post_sw .post_s{
        top: calc(var(--jl-sec-menu-height) + 50px) !important;
    }
<?php }?>
<?php if( !empty($category_label_padding) || !empty($category_label_radius) ){?>
.jl_lb3 .jl_cat_lbl, .jl_lb4 .jl_cat_lbl, .jl_lb5 .jl_cat_lbl, .jl_lb6 .jl_cat_lbl, .jl_lb7 .jl_cat_lbl{
    padding: <?php echo esc_attr($category_label_padding);?> !important;
    border-radius: <?php echo esc_attr($category_label_radius);?> !important;
}
<?php }?>
<?php if( !empty(get_theme_mod('ac_menu_line_height')) ){?>
.navigation_wrapper .jl_main_menu > .menu-item:hover > a .jl_mblt, .navigation_wrapper .jl_main_menu > .current-menu-ancestor > a .jl_mblt, .navigation_wrapper .jl_main_menu > .current-menu-item > a .jl_mblt, .navigation_wrapper .jl_main_menu > .is-current-sub > a .jl_mblt{
    background-size: 100% <?php echo esc_attr(get_theme_mod('ac_menu_line_height','1px'));?> !important;
}
<?php }?>
<?php if( !empty(get_theme_mod('ac_menu_line_color')) ){?>
.navigation_wrapper .jl_main_menu > .menu-item > a .jl_mblt{
    background-image: linear-gradient(90deg,<?php echo esc_attr(get_theme_mod('ac_menu_line_color'));?> 0,<?php echo esc_attr(get_theme_mod('ac_menu_line_color'));?> 94%);
    background-size: 0 <?php echo esc_attr(get_theme_mod('ac_menu_line_height','1px'));?>;
}
<?php }?>
<?php if( !empty($max_content_width) ){?>
.jlc-container{max-width: <?php echo esc_attr($max_content_width);?>;}
<?php }?>
<?php if(get_theme_mod('single_order_1', 'jl_sli_fb')){?>
.jl_sli_in .<?php echo esc_attr(get_theme_mod('single_order_1','jl_sli_fb'));?>{order: 1;}
<?php }?>
<?php if(get_theme_mod('single_order_2', 'jl_sli_tw')){?>
.jl_sli_in .<?php echo esc_attr(get_theme_mod('single_order_2','jl_sli_tw'));?>{order: 2;}
<?php }?>
<?php if(get_theme_mod('single_order_3', 'jl_sli_pi')){?>
.jl_sli_in .<?php echo esc_attr(get_theme_mod('single_order_3','jl_sli_pi'));?>{order: 3;}
<?php }?>
<?php if(get_theme_mod('single_order_4', 'jl_sli_din')){?>
.jl_sli_in .<?php echo esc_attr(get_theme_mod('single_order_4','jl_sli_din'));?>{order: 4;}
<?php }?>
<?php if(get_theme_mod('single_order_5', 'jl_sli_wapp')){?>
.jl_sli_in .<?php echo esc_attr(get_theme_mod('single_order_5','jl_sli_wapp'));?>{order: 5;}
<?php }?>
<?php if(get_theme_mod('single_order_6', 'jl_sli_tele')){?>
.jl_sli_in .<?php echo esc_attr(get_theme_mod('single_order_6','jl_sli_tele'));?>{order: 6;}
<?php }?>
.jl_sli_in .jl_sli_tumblr{order: 7;}
.jl_sli_in .jl_sli_line{order: 7;}
<?php if(get_theme_mod('single_order_7', 'jl_sli_mil')){?>
.jl_sli_in .<?php echo esc_attr(get_theme_mod('single_order_7','jl_sli_mil'));?>{order: 7;}
<?php }?>

<?php if(get_theme_mod('disable_l_share_fb') ==1){?>
.post_sw .jl_sli_in .jl_sli_fb{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_l_share_tw') ==1){?>
.post_sw .jl_sli_in .jl_sli_tw{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_l_share_pin') ==1){?>
.post_sw .jl_sli_in .jl_sli_pi{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_l_share_in') ==1){?>
.post_sw .jl_sli_in .jl_sli_din{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_l_share_whatsapp') ==1){?>
.post_sw .jl_sli_in .jl_sli_wapp{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_l_share_telegram', 1) ==1){?>
.post_sw .jl_sli_in .jl_sli_tele{display: none !important;}
<?php }?>

<?php if(get_theme_mod('disable_l_share_tumblr', 1) ==1){?>
.post_sw .jl_sli_in .jl_sli_tumblr{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_l_share_line', 1) ==1){?>
.post_sw .jl_sli_in .jl_sli_line{display: none !important;}
<?php }?>

<?php if(get_theme_mod('disable_l_share_mail', 1) ==1){?>
.post_sw .jl_sli_in .jl_sli_mil{display: none !important;}
<?php }?>

<?php if(get_theme_mod('disable_s_share_fb') ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_fb{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_tw') ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_tw{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_pin') ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_pi{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_in') ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_din{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_whatsapp') ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_wapp{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_telegram') ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_tele{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_tumblr', 1) ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_tumblr{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_line', 1) ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_line{display: none !important;}
<?php }?>
<?php if(get_theme_mod('disable_s_share_mail') ==1){?>
.jl_sfoot .jl_sli_in .jl_sli_mil{display: none !important;}
<?php }?>
.logo_small_wrapper_table .logo_small_wrapper a .jl_logo_w {
    position: absolute;top: 0px;left: 0px;opacity: 0;
}
.logo_small_wrapper_table .logo_small_wrapper .logo_link img{
    max-width: var(--jl-logo-width);
}
.jl_sleft_side .jl_smmain_side{
    order: 1;
    padding-left: 20px;
    padding-right: 30px;
}
.jl_sleft_side .jl_smmain_con{
    order: 2;
}
.jl_rd_wrap{
    <?php echo esc_attr($sp_progress_pos);?>: 0;    
}
.jl_rd_read{
    height: <?php echo esc_attr($sp_progress_height);?>;    
    background-color: <?php echo esc_attr($sp_color2);?>;
    background-image: linear-gradient(to right, <?php echo esc_attr($sp_color1);?> 0%, <?php echo esc_attr($sp_color2);?> 100%);
}
.jl_view_none{display: none;}
.jl_sifea_img, .jl_smmain_w .swiper-slide-inner{
    border-radius: var(--jl-border-rounded);
    overflow: hidden;
}
.jl_shead_mix12 .jl_ov_layout, .jl_shead_mix10 .jl_ov_layout, .jl_shead_mix9 .jl_ov_layout{
    border-radius: 0px;
}
<?php if(!empty(get_theme_mod('disable_author_box_img'))){?>
.jl_info_auth .author-avatar{display: none;}
<?php }?>
<?php
$jl_cat_color = get_terms('category');
    if ($jl_cat_color) {
        foreach( $jl_cat_color as $tag) {
            $tag_link = get_category_link($tag->term_id);
            $cat_color = get_term_meta($tag->term_id, "category_color_options", true);
            if( !empty($cat_color) ){
                echo '.cat-item-'.$tag->term_id.' span{background: '.esc_attr($cat_color).'}';
                echo '.jl_cat_cid_'.esc_attr($tag->term_id).' .jl_cm_count{background: '.esc_attr($cat_color).' !important;}';
                echo '.jl_cat_opt4 .jl_cat_opt_w.jl_cat_cid_'.esc_attr($tag->term_id).'{background: '.esc_attr($cat_color).' !important;}';
                echo '.jl_cat_txt.jl_cat'.esc_attr($tag->term_id).':before{background: '.esc_attr($cat_color).';}';
                echo '.jl_cat_lbl.jl_cat'.esc_attr($tag->term_id).'{background: '.esc_attr($cat_color).';}';
            }
        }
    }
?>