<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action('widgets_init', 'wesper_recent_large__widgets');

function wesper_recent_large__widgets() {
    register_widget('wesper_recent_large_widgets');
}

class wesper_recent_large_widgets extends WP_Widget {

/*-----------------------------------------------------------------------------------*/
/*  Widget Setup
/*-----------------------------------------------------------------------------------*/

    public function __construct() {
        $widget_ops = array(
            'classname' => 'main_post_style',
            'description' => esc_html__('Display post on menu or widget.', 'wesper')
        );
        parent::__construct('wesper_recent_large_widgets', esc_html__('&nbsp;Recent post large', 'wesper'), $widget_ops);
    }

/*-----------------------------------------------------------------------------------*/
/*  Display Widget
/*-----------------------------------------------------------------------------------*/
    function widget($args, $instance) {

        extract($args);

        $cats = isset($instance["cats"]) ? $instance["cats"] : "";
        $title = isset($instance['title']) ? esc_attr($instance['title']) : 'Recent Posts';
        $number = isset($instance['number']) ? absint($instance['number']) : 4;
        $number_offset = isset($instance['number_offset']) ? absint($instance['number_offset']) : 0;

        print $before_widget;

        // Widget title

        if ( $title ){ 
        print $before_title;
        print esc_attr($title);
        print $after_title;
        }
       ?>
        <div class="jl_wgli_w">
            <?php $jellywp_args = array(
                        'showposts' => $number,
                        'ignore_sticky_posts' => 1,
                        'category__in' => $cats,
                        'offset' => $number_offset
            );
            $jellywp_widget = null;
            $jellywp_widget = new WP_Query($jellywp_args);
            ?>
            <?php while ($jellywp_widget->have_posts()) {
                $jellywp_widget->the_post();?>                         
                <div class="jl_cgrid_layout">
                    <?php if ( has_post_thumbnail()) {?>
                        <div class="jl_img_holder">
                        <div class="jl_imgw jl_radus_e">
                            <div class="jl_imgin">
                                <?php the_post_thumbnail('wesper_layouts');?>
                            </div>
                            <?php wesper_video_media(get_the_ID());?>
                            <?php wesper_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
                            <a class="jl_imgl" href="<?php the_permalink();?>"></a>
                        </div>
                        </div>
                    <?php }?>
                    <div class="jl_fe_text">
                        <?php wesper_post_cat(get_the_ID());?>
                        <h3 class="jl_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
                        <?php wesper_post_meta(get_the_ID());?>
                    </div>
                </div>              
            <?php }?>
        </div>
<?php
wp_reset_postdata();
print $after_widget;
}

/*-----------------------------------------------------------------------------------*/
/*  Update Widget
/*-----------------------------------------------------------------------------------*/

function update( $new_instance, $old_instance ) {
    $instance = $old_instance;
    $instance['title'] = strip_tags($new_instance['title']);
    $instance['cats'] = isset($new_instance['cats']) ? $new_instance['cats'] : "";
    $instance['number'] = absint($new_instance['number']);
    $instance['number_offset'] = absint($new_instance['number_offset']);
     
    return $instance;
}


function form( $instance ) {
    $title = isset($instance['title']) ? esc_attr($instance['title']) : 'Recent Posts';
    $number = isset($instance['number']) ? absint($instance['number']) : 4;
    $number_offset = isset($instance['number_offset']) ? absint($instance['number_offset']) : 0;
?>
<p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
        <?php esc_html_e('Title:', 'wesper'); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

<p><label for="<?php echo esc_attr($this->get_field_id('number')); ?>">
        <?php esc_html_e('Number of posts to show:', 'wesper'); ?></label>
    <input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr($number); ?>" style="width: 100%;"  /></p>

<p><label for="<?php echo esc_attr($this->get_field_id('number_offset')); ?>">
        <?php esc_html_e('Offset posts:', 'wesper'); ?></label>
    <input id="<?php echo esc_attr($this->get_field_id('number_offset')); ?>" name="<?php echo esc_attr($this->get_field_name('number_offset')); ?>" type="text" value="<?php echo esc_attr($number_offset); ?>" style="width: 100%;" /></p>
<p>
    <label for="<?php echo esc_attr($this->get_field_id('cats')); ?>">
        <?php esc_html_e('Choose your category:', 'wesper');?>
        <?php
                   $categories=  get_categories();
                     print "<br/>";
                     foreach ($categories as $cat) {
                    $option = '<input type="checkbox" id="' . $this->get_field_id('cats') . '[]" name="' . $this->get_field_name('cats') . '[]"';
              
                    if (!empty($instance['cats'])) {
                        foreach ($instance['cats'] as $cats) {
                            if ($cats == $cat->term_id) {
                                $option = $option . ' checked="checked"';
                            }
                        }
                    }              
                    $option .= ' value="' . $cat->term_id . '" />';
                    $option .= '&nbsp;';
                    $option .= $cat->cat_name.' ('.esc_html( $cat->category_count ).')';
                    $option .= '<br />';
                    print $option;
                }
                    
                    ?>
    </label>
</p>
<?php }}?>