<?php
if ( ! defined( 'ABSPATH' ) ) exit;
add_action('widgets_init','wesper_author_widget_init');
function wesper_author_widget_init(){
		register_widget("wesper_author_widget");
}

class wesper_author_widget extends WP_widget{

/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/

	public function __construct() {
		$widget_ops = array( 'classname' => 'jellywp_author_widget', 'description' => esc_html__( 'List all authors' , 'wesper') );
		parent::__construct('wesper_author_widget', esc_html__('&nbsp;Authors list', 'wesper'), $widget_ops);
        $this->defaults = array('authors' => array() );
	}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	function widget($args,$instance){
    extract($args);
    $title = isset($instance['title']) ? $instance['title'] : "";
    $params = array_merge( $this->defaults, $instance );		      
    ?>
<?php print $before_widget;?>
<div class="widget_jl_wrapper jl_author_widget_content">
    <?php if($title) { print $before_title.esc_attr($title).$after_title; }?>
    <div class="jl_author_main">
    <?php if ( $params['authors'] ) {
            foreach ( $params['authors'] as $id ) {?>
                <div class="jl_m_right jl_lisep">
                    <div class="jl_m_right_img jl_radus_e">
                        <a href="<?php echo get_author_posts_url( $id ); ?>">
                        <?php echo get_avatar( $id, '140', '', '', array( 'class' => 'lazyload' )); ?>
                        </a>
                    </div>
                    <div class="jl_m_right_content">
                        <h2 class="jl_fe_title"><a href="<?php echo get_author_posts_url( $id ); ?>"><?php the_author_meta( 'display_name', $id ); ?></a></h2>
                        <p><?php echo wp_trim_words( get_the_author_meta( 'description', $id ), 9, '...' );?> </p>                        
                        <?php if(function_exists('wesper_author_share_link')){wesper_author_list_share($id);}?>
                    </div>
                </div>
                <?php
            }}?>
    </div>
    <?php
	print $after_widget;
	print "</div>";
	}

/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
        $instance = $new_instance;
        $instance['title'] = $new_instance['title'];        
        return $instance;
    }

	function form($instance){
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $params = array_merge( $this->defaults, $instance );
	?>
    <p>
        <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
            <?php esc_html_e( 'Title:', 'wesper'); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
    </p>
    <p>
        <label for="<?php echo esc_attr( $this->get_field_id( 'authors' ) ); ?>"><?php esc_html_e( 'Authors', 'wesper' ); ?></label>
        <select name="<?php echo esc_attr( $this->get_field_name( 'authors' ) ); ?>[]" id="<?php echo esc_attr( $this->get_field_id( 'authors' ) ); ?>" class="widefat" style="height: auto !important;" multiple="multiple" size="8">
                    <?php
                        $authors = get_users(
                            array(
                                'role__not_in' => array( '1', '2' ),
                            )
                        );
                    if ( $authors ) {
                        foreach ( $authors as $author ) {
                            ?>
                                <option value="<?php echo esc_attr( $author->ID ); ?>" <?php selected( true, in_array( $author->ID, $params['authors'] ) ); ?>><?php echo esc_html( $author->data->display_name ); ?></option>
                                <?php
                        }
                    }
                    ?>
                </select>
            </p>
    <?php
	}
}
?>