'use strict';

window.wesper = {};

(
function(wesper, $) {
    wesper = wesper || {};

    $.extend(wesper, {
        Swatches: {
            init: function() {
                var $term = $('.wesper-term'),
                $active_term = $('.wesper-term:not(.wesper-disabled)');

                // load default value
                $term.each(function() {
                    var $this       = $(this),
                        term        = $this.attr('data-term'),
                        attr        = $this.closest('.wesper-terms').attr('data-attribute'),
                        $select_box = $this.closest('.wesper-terms').parent().find('select#' + attr),
                        val         = $select_box.val();

                    if ( val != '' && term == val ) {
                        $(this).addClass('wesper-selected').find('input[type="radio"]').prop('checked', true);
								
						
                    }
                });

				
                $active_term.unbind('click touch').on('click touch', function(e) {
                    var $this       = $(this),
                        term        = $this.attr('data-term'),
                        title       = $this.attr('title'),
                        attr        = $this.closest('.wesper-terms').attr('data-attribute'),
                        $select_box = $this.closest('.wesper-terms').parent().find('select#' + attr);

                    if ( $this.hasClass('wesper-disabled') ) {
                        return false;
                    }

                    if ( !$this.hasClass('wesper-selected') ) {
                        $select_box.val(term).trigger('change');

                        $this.closest('.wesper-terms').find('.wesper-selected').removeClass('wesper-selected').find('input[type="radio"]').prop('checked', false);

                        $this.addClass('wesper-selected').find('input[type="radio"]').prop('checked', true);

                        $(document).trigger('wesper_selected', [attr, term, title]);
                    }

                    e.preventDefault();
                });

                $(document).on('woocommerce_update_variation_values', function(e) {
                    $(e['target']).find('select').each(function() {
                        var $this = $(this);
                        var $terms = $this.parent().parent().find('.wesper-terms');

                        $terms.find('.wesper-term').removeClass('wesper-enabled').addClass('wesper-disabled');

                        $this.find('option.enabled').each(function() {
                            var val = $(this).val();

                            $terms.find('.wesper-term[data-term="' + val + '"]').removeClass('wesper-disabled').addClass('wesper-enabled');
                        });
                    });
                });
				
				
				$('table.variations tr').each(function() {
					if($(this).find('.wesper-selected').length !== 0){
						$(this).find('label').append('<span class="selected-value">: '+ $(this).find('.wesper-selected').html() +'</span>');
					}
				});
				
				$(document).on('wesper_selected', function(e) {
					$('span.selected-value').remove();
					$('table.variations tr').each(function() {
						if($(this).find('.wesper-selected').length !== 0){
							$(this).find('label').append('<span class="selected-value">: '+ $(this).find('.wesper-selected').html() +'</span>');
						}
					});
				});
				
				
                $(document).on('reset_data', function(e) {
                    $(document).trigger('wesper_reset');
                    var $this = $(e['target']);
					
					$('span.selected-value').remove();
					
                    $this.find('.wesper-selected').removeClass('wesper-selected').find('input[type="radio"]').prop('checked', false);

                    $this.find('select').each(function() {
                        var attr = $(this).attr('id');
                        var title = $(this).find('option:selected').text();
                        var term = $(this).val();

                        if ( term != '' ) {
                            $(this).parent().parent().
                            find('.wesper-term[data-term="' + term + '"]').
                            addClass('wesper-selected').find('input[type="radio"]').
                            prop('checked', true);

                            $(document).trigger('wesper_reset', [attr, term, title]);
                        }
                    });
                });
            }
        }
    });

}).apply(this, [window.wesper, jQuery]);

(
function(wesper, $) {

    $(document).on('wc_variation_form', function() {
        if ( typeof wesper.Swatches !== 'undefined' ) {
            wesper.Swatches.init();
        }
    });
    $(document.body).on('wesper_variations_init', function() {
        if ( typeof wesper.Swatches !== 'undefined' ) {
            wesper.Swatches.init();
        }
        $('.wesper-products-wrapper .variations_form').each(function () {
            $(this).wc_variation_form();
        });
    });

    $(document).on('found_variation', function(e, t) {
        if ( $(e['target']).closest('.wesper-loop-swatches').length ) {
            var $product  = $(e['target']).closest('.wesper-product'),
                $atc      = $product.find('.add_to_cart_button'),
                $image    = $product.find('.attachment-woocommerce_thumbnail'),
                $price    = $product.find('.price');

            if ( $atc.length ) {
                $atc.addClass('wesper_add_to_cart').attr('data-variation_id', t['variation_id']).attr('data-product_sku', t['sku']);

                if ( !t['is_purchasable'] || !t['is_in_stock'] ) {
                    $atc.addClass('disabled wc-variation-is-unavailable');
                } else {
                    $atc.removeClass('disabled wc-variation-is-unavailable');
                }

                $atc.removeClass('added error loading');
            }

            $product.find('a.added_to_cart').remove();

            // add to cart button text
            if ( $atc.length ) {
                $atc.text(wesper_vars.strings.button.add_to_cart);
            }

            // product image
            if ( $image.length ) {

                if ( $image.attr('data-src') == undefined ) {
                    $image.attr('data-src', $image.attr('src'));
                }

                if ( $image.attr('data-srcset') == undefined ) {
                    $image.attr('data-srcset', $image.attr('srcset'));
                }

                if ( $image.attr('data-sizes') == undefined ) {
                    $image.attr('data-sizes', $image.attr('sizes'));
                }

                if ( t['image']['src'] != undefined && t['image']['src'] != '' ) {
                    $image.attr('src', t['image']['src']);
                }

                if ( t['image']['srcset'] != undefined && t['image']['srcset'] != '' ) {
                    $image.attr('srcset', t['image']['srcset']);
                } else {
                    $image.attr('srcset', '');
                }

                if ( t['image']['sizes'] != undefined && t['image']['sizes'] != '' ) {
                    $image.attr('sizes', t['image']['sizes']);
                } else {
                    $image.attr('sizes', '');
                }
            }

            // product price
            if ( $price.length ) {
                if ( $price.attr('data-price') == undefined ) {
                    $price.attr('data-price', $price.html());
                }

                if ( t['price_html'] ) {
                    $price.html( t['price_html'] );
                }
            }

            $(document).trigger('wesper_archive_found_variation', [t]);
        }
    });

    $(document).on('reset_data', function(e) {
        if ( $(e['target']).closest('.wesper-loop-swatches').length ) {
            var $product  = $(e['target']).closest('.wesper-product'),
                $atc      = $product.find('.add_to_cart_button'),
                $image    = $product.find('.attachment-woocommerce_thumbnail'),
                $price    = $product.find('.price');

            if ( $atc.length ) {
                $atc.removeClass('wesper_add_to_cart disabled wc-variation-is-unavailable').attr('data-variation_id', '0').attr('data-product_sku', '');
                    $atc.removeClass('added error loading');
                }

                $product.find('a.added_to_cart').remove();

                // add to cart button text
                if ( $atc.length ) {
                    $atc.text(wesper_vars.strings.button.select_options);
                }

                // product image
                if ( $image.length ) {
                    $image.attr('src', $image.attr('data-src'));
                    $image.attr('srcset', $image.attr('data-srcset'));
                    $image.attr('sizes', $image.attr('data-sizes'));
                }

                // product price
                if ( $price.length ) {
                    $price.html($price.attr('data-price'));
                }

                $(document).trigger('wesper_archive_reset_data');
            }
        });

        $(document).on('click touch', '.wesper_add_to_cart', function(e) {
            e.preventDefault();
            var $this = $(this);
            var $product = $this.closest('.wesper-product');
            var attributes = {};

            $this.removeClass('added error').addClass('loading');

            if ($product.length) {
                $product.find('a.added_to_cart').remove();

                $product.find('[name^="attribute"]').each(function() {
                    attributes[$(this).attr('data-attribute_name')] = $(this).val();
                });

                var data = {
                    action       : 'product_attribute_add_to_cart',
                    nonce        : wesper_vars.security,
                    product_id   : $this.attr('data-product_id'),
                    variation_id : $this.attr('data-variation_id'),
                    quantity     : $this.attr('data-quantity'),
                    attributes   : JSON.stringify(attributes),
                };

                $.post(wesper_vars.ajax_url, data, function(response) {
                    if (response) {
                        $this.removeClass('loading').addClass('added');
                        $(document.body).trigger('added_to_cart').trigger('wc_fragment_refresh');
                    } else {
                        $this.removeClass('loading').addClass('error');
                    }
                });
            }
        });
		
		
	

    }
).apply(this, [window.wesper, jQuery]);
