<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
defined('ABSPATH') || die();

class wesper_section_main_menu extends Widget_Base {

    public function get_name() {
        return 'wesper-main-menu';
    }

    public function get_title() {
        return esc_html__( 'Jelly Main Menu', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-nav-menu jl-icons';
    }

    public function get_categories() {
        return [ 'wesper-elements-head' ];
    }

    protected function register_controls() {
    $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Main Menu', 'wesper' ),
            ]
        );
            
            if ( ! empty( wesper_get_menus() ) ) {        
                $this->add_control(
                    'inline_menu_slug',
                    [
                        'label'   => esc_html__( 'Menu', 'wesper' ),
                        'type'    => Controls_Manager::SELECT,
                        'options' => wesper_get_menus(),
                        'default' => array_keys( wesper_get_menus() )[0],
                        'save_default' => true,
                        'separator' => 'after',
                        'description' => sprintf( __( 'Go to the <a href="%s" target="_blank">Menus Option</a> to manage your menus.', 'wesper' ), admin_url( 'nav-menus.php' ) ),
                    ]
                );
            } else {
                $this->add_control(
                    'inline_menu_notice',
                    [
                        'type' => Controls_Manager::RAW_HTML,
                        'raw' => sprintf( __( '<strong>There are no menus in your site.</strong><br>Go to the <a href="%s" target="_blank">Menus Option</a> to create one.', 'wesper' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
                        'separator' => 'after',
                    ]
                );
            }

        $this->end_controls_section();
                
        $this->start_controls_section(
            'menu_item_style_section',
            [
                'label' => esc_html__( 'Menu Item', 'wesper' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'menu_bg_style',
            [
                'label'     =>esc_html__( 'Menu hover & active style', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'default',
                'options'   => [
                        'default'      =>esc_html__( 'Hover line animation', 'wesper' ),
                        'jl_menu_hover_bg'    =>esc_html__( 'Hover background', 'wesper' ),
                        'jl_menu_hover_scale_bg'    =>esc_html__( 'Hover scale background', 'wesper' ),
                        'jl_menu_hove_line_bottom'    =>esc_html__( 'Hover line bottom', 'wesper' )
                    ],
            ]
        );

        $this->add_responsive_control(
                'area_alignment',
                [
                    'label'   => esc_html__( 'Alignment', 'wesper' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'wesper' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'wesper' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Right', 'wesper' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper'   => 'justify-content: {{VALUE}};',
                    ],
                    'prefix_class'=>'htmove-menu-align-%s',
                ]
            );
            
            $this->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name' => 'menu_item_typography',
                    'label' => esc_html__( 'Typography', 'wesper' ),
                    'selector' => '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a',
                ]
            );

            $this->add_responsive_control(
                'menu_main_height',
                [
                    'label' => esc_html__( 'Height', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                    'unit' => 'px',
                    'size' => 90,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper' => 'height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .navigation_wrapper > div' => 'height: 100%;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'menu_main_scale',
                [
                    'label' => esc_html__( 'Manu scale size', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                    'unit' => 'px',
                    'size' => 3,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper' => '--jl-menuscale: -{{SIZE}}{{UNIT}}; --jl-menuscale-size: calc( {{SIZE}}{{UNIT}} * 2);',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item:hover > a' => 'margin-top: var(--jl-menuscale); height: calc(100% + var(--jl-menuscale-size));',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-ancestor > a' => 'margin-top: var(--jl-menuscale); height: calc(100% + var(--jl-menuscale-size));',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-item > a' => 'margin-top: var(--jl-menuscale); height: calc(100% + var(--jl-menuscale-size));',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .is-current-sub > a' => 'margin-top: var(--jl-menuscale); height: calc(100% + var(--jl-menuscale-size));',                           
                    ],
                    'condition' => [
                        'menu_bg_style'    => ['jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_responsive_control(
                'menu_main_line_bottom',
                [
                    'label' => esc_html__( 'Menu line size', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                    'unit' => 'px',
                    'size' => 2,
                    ],
                    'selectors' => [                        
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a span.jl_mblt' => 'background-image: unset !important; border-bottom: {{SIZE}}{{UNIT}} solid transparent; display: flex; align-items: center; transition: all 0.13s ease 0s;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item:hover > a .jl_mblt' => 'border-bottom: {{SIZE}}{{UNIT}} solid currentColor;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-ancestor > a .jl_mblt' => 'border-bottom: {{SIZE}}{{UNIT}} solid currentColor;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-item > a .jl_mblt' => 'border-bottom: {{SIZE}}{{UNIT}} solid currentColor;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .is-current-sub > a .jl_mblt' => 'border-bottom: {{SIZE}}{{UNIT}} solid currentColor;',                           
                    ],
                    'condition' => [
                        'menu_bg_style'    => ['jl_menu_hove_line_bottom']
                    ]
                ]
            );

            $this->add_control(
                'jl_line_full_height',
                [
                    'label' => esc_html__( 'Line full height', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a .jl_mblt' => 'height: 100% !important;',
                    ],
                    'condition' => [
                        'menu_bg_style'    => ['jl_menu_hove_line_bottom']
                    ]
                ]
    );

            $this->add_responsive_control(
                'menu_item_space',
                [
                    'label' => esc_html__( 'Space', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 300,
                            'step' => 1,
                        ]                        
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'menu_bg_style!'    => ['jl_menu_hover_bg','jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_responsive_control(
                'menu_item_padding',
                [
                    'label' => esc_html__( 'Padding menu', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],                    
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 300,
                            'step' => 1,
                        ]                        
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a' => 'padding: 0px {{SIZE}}{{UNIT}} 0px {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'menu_bg_style'    => ['jl_menu_hover_bg','jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_responsive_control(
                'menu_item_spacing',
                [
                    'label' => esc_html__( 'Spacing menu', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'size' => 17,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 300,
                            'step' => 1,
                        ]                        
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'menu_bg_style'    => ['jl_menu_hover_bg','jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_responsive_control(
                'menu_item_line',
                [
                    'label' => esc_html__( 'Hover line height', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ]                        
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item:hover > a .jl_mblt' => 'background-size: 100% {{SIZE}}{{UNIT}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-ancestor > a .jl_mblt' => 'background-size: 100% {{SIZE}}{{UNIT}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-item > a .jl_mblt' => 'background-size: 100% {{SIZE}}{{UNIT}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .is-current-sub > a .jl_mblt' => 'background-size: 100% {{SIZE}}{{UNIT}} !important;',                        
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a .jl_mblt' => 'background-size: 0 {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'menu_bg_style!'    => ['jl_menu_hover_bg','jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_control(
                'jl_menu_bg',
                [
                    'label'     => esc_html__( 'Menu active & hover background', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a .jl_mblt' => 'background-image: unset !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item:hover > a' => 'background: {{VALUE}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-ancestor > a' => 'background: {{VALUE}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-item > a' => 'background: {{VALUE}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .is-current-sub > a' => 'background: {{VALUE}} !important;',                        
                        
                    ],
                    'condition' => [
                        'menu_bg_style'    => ['jl_menu_hover_bg','jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_control(
                'jl_menu_bg_dark',
                [
                    'label'     => esc_html__( 'Menu active & hover background dark mode', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item:hover > a' => 'background: {{VALUE}} !important;',
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-ancestor > a' => 'background: {{VALUE}} !important;',
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-item > a' => 'background: {{VALUE}} !important;',
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .is-current-sub > a' => 'background: {{VALUE}} !important;',                        
                    ],
                    'condition' => [
                        'menu_bg_style'    => ['jl_menu_hover_bg','jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_control(
                'line_run_color',
                [
                    'label'     => esc_html__( 'Hover line color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a .jl_mblt' => 'background-image: linear-gradient(90deg,{{VALUE}} 0,{{VALUE}} 94%);',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item:hover > a .jl_mblt' => 'border-color: {{VALUE}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-ancestor > a .jl_mblt' => 'border-color: {{VALUE}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-item > a .jl_mblt' => 'border-color: {{VALUE}} !important;',
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .is-current-sub > a .jl_mblt' => 'border-color: {{VALUE}} !important;',
                    ],
                    'condition' => [
                        'menu_bg_style!'    => ['jl_menu_hover_bg','jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_control(
                'line_run_color_dark',
                [
                    'label'     => esc_html__( 'Hover line color dark mode', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a .jl_mblt' => 'background-image: linear-gradient(90deg,{{VALUE}} 0,{{VALUE}} 94%);',
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item:hover > a .jl_mblt' => 'border-color: {{VALUE}} !important;',
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-ancestor > a .jl_mblt' => 'border-color: {{VALUE}} !important;',
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .current-menu-item > a .jl_mblt' => 'border-color: {{VALUE}} !important;',
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .is-current-sub > a .jl_mblt' => 'border-color: {{VALUE}} !important;',
                    ],
                    'condition' => [
                        'menu_bg_style!'    => ['jl_menu_hover_bg','jl_menu_hover_scale_bg']
                    ]
                ]
            );

            $this->add_control(
                'menu_normal_color',
                [
                    'label'     => esc_html__( 'Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default' => '#000',
                    'selectors' => [
                        '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'menu_normal_color_dark',
                [
                    'label'     => esc_html__( 'Color dark mode', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default' => '#FFF',
                    'selectors' => [
                        '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item > a' => 'color: {{VALUE}};',
                    ],
                ]
            );
                
            $this->add_control(
                    'menu_hover_color',
                    [
                        'label'     => esc_html__( 'Color hover', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'default' => '#000',
                        'selectors' => [
                            '{{WRAPPER}} .jl_main_menu .menu-item:hover > a' => 'color: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_control(
                    'menu_hover_color_dark',
                    [
                        'label'     => esc_html__( 'Color hover dark mode', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'default' => '#FFF',
                        'selectors' => [
                            '.options_dark_skin {{WRAPPER}} .jl_main_menu .menu-item:hover > a' => 'color: {{VALUE}};',
                        ],
                    ]
                );
        $this->end_controls_section();

        $this->start_controls_section(
            'sub_menu_item',
            [
                'label' => esc_html__( 'Sub Menu Item', 'wesper' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );         
        
        $this->add_control(
            'mega_menu_layout',
            [
                'label'     =>esc_html__( 'Mega menu layout', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'full_width',
                'options'   => [
                        'full_width'      =>esc_html__( 'Full width', 'wesper' ),
                        'boxed_width'    =>esc_html__( 'Boxed width', 'wesper' ),                        
                    ],
            ]
        );

        $this->add_responsive_control(
            'mega_menu_with',
            [
                'label' => esc_html__( 'Mega menu width', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                        'step' => 1,
                    ]                        
                ],
                'selectors' => [
                    '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu .jl_mega_inner' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'jl_show_border_menu',
            [
                'label' => esc_html__( 'Sub menu border', 'wesper' ),
                'type' => Controls_Manager::SWITCHER,                                
            ]
            );
            
        $this->add_responsive_control(
            'sub_menu_border',
            [
                'label' => esc_html__( 'Sub menu items border', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ]                        
                ],
                'default' => [
                'unit' => 'px',
                'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .navigation_wrapper .jl_main_menu .menu-item:not(.menupost) .sub-menu .menu-item' => 'border: {{SIZE}}{{UNIT}} solid; margin-bottom:-{{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .navigation_wrapper .sub-menu:not(.menupost) .menu-item > .sub-menu' => 'margin-top:-{{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu:not(.menupost)' => 'padding: 0px !important; margin-left: 0px !important; margin-right: 0px !important;',
                    '{{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu:not(.menupost) .menu-item > a .jl_mblt' => 'background-image: unset !important;',
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );        

        $this->add_control(
            'sub_menu_border_color',
            [
                'label'     => esc_html__( 'Border color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '{{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu:not(.menupost) .menu-item' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sub_menu_border_color_dark',
            [
                'label'     => esc_html__( 'Border color dark mode', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu:not(.menupost) .menu-item' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sub_menu_hover_bg',
            [
                'label'     => esc_html__( 'Hover background', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '{{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu:not(.menupost) .menu-item:hover > a' => 'background: {{VALUE}} !important;',
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sub_menu_hover_bg_dark',
            [
                'label'     => esc_html__( 'Hover background dark mode', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                    
                    '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu:not(.menupost) .menu-item:hover > a' => 'background: {{VALUE}} !important;',
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );    
        
        $this->add_responsive_control(
            'sub_menu_padding',
            [
                'label'      => esc_html__( 'Sub menu padding', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .menu-item:not(.menupost) .menu-item a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .navigation_wrapper .jl_main_menu ul .menu-item-has-children > a:after' => 'right: {{RIGHT}}{{UNIT}};'                    
                ],
                'condition' => [
                    'jl_show_border_menu' => 'yes'
                ]
            ]
        );

        $this->add_control(
                        'sub_menu_bg_color',
                        [
                            'label'     => esc_html__( 'Background color', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .navigation_wrapper .jl_main_menu .menu-item .sub-menu' => 'background: {{VALUE}};',
                                '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu .jl_mega_inner' => 'box-shadow: unset !important; background: transparent !important;',
                            ],
                            'condition' => [
                                'mega_menu_layout'    => ['full_width']
                            ]
                        ]
        );

                    $this->add_control(
                        'sub_menu_bg_color_dark',
                        [
                            'label'     => esc_html__( 'Background color dark mode', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu .menu-item .sub-menu' => 'background: {{VALUE}};',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu .jl_mega_inner' => 'box-shadow: unset !important; background: transparent !important;',
                            ],
                            'condition' => [
                                'mega_menu_layout'    => ['full_width']
                            ]
                        ]
                    );

                    $this->add_control(
                        'sub_menu_box_bg_color',
                        [
                            'label'     => esc_html__( 'Background color', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .navigation_wrapper .jl_main_menu .menu-item .sub-menu' => 'background: {{VALUE}};',
                                '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu' => 'background: transparent !important; box-shadow: unset !important;',
                                '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu .jl_mega_inner' => 'box-shadow: 0px 32px 64px -16px rgb(0 0 0 / 16%) !important; background: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'mega_menu_layout'    => ['boxed_width']
                            ]
                        ]
                    );

                    $this->add_control(
                        'sub_menu_box_bg_color_dark',
                        [
                            'label'     => esc_html__( 'Background color dark mode', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu .menu-item .sub-menu' => 'background: {{VALUE}};',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu' => 'background: transparent !important; box-shadow: unset !important;',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item > .jl-cus-mega-menu.sub-menu .jl_mega_inner' => 'box-shadow: 0px 32px 64px -16px rgb(0 0 0 / 16%) !important; background: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'mega_menu_layout'    => ['boxed_width']
                            ]
                        ]
                    );
                    
            
                    

            $this->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name' => 'sub_menu_item_typography',
                    'label' => esc_html__( 'Typography', 'wesper' ),
                    'selector' => '{{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu .menu-item a',
                ]
            );            
                    
                    $this->add_control(
                        'sub_menu_normal_color',
                        [
                            'label'     => esc_html__( 'Color', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu .menu-item a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .navigation_wrapper .mega-category-menu .jl_f_cat .jl_cat_txt' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .sub-menu .jl_mega_gl .jl_fe_title' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .sub-menu .jl_mega_sml .jl_fe_title' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .sub-menu .jl_mega_gl .jl_fe_title a' => 'color: currentColor !important;',
                                '{{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .sub-menu .jl_mega_sml .jl_fe_title a' => 'color: currentColor !important;',
                                '{{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .jl_mega_gl .jl_post_meta span, {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .jl_mega_gl .jl_post_meta span a' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .jl_mega_sml .jl_post_meta span, {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .jl_mega_sml .jl_post_meta span a' => 'color: {{VALUE}} !important;',                                
                            ],
                        ]
                    );

                    $this->add_control(
                        'sub_menu_normal_color_dark',
                        [
                            'label'     => esc_html__( 'Color dark mode', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu .menu-item a' => 'color: {{VALUE}};',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu .jl_f_cat .jl_cat_txt' => 'color: {{VALUE}};',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .sub-menu .jl_mega_gl .jl_fe_title' => 'color: {{VALUE}} !important;',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .sub-menu .jl_mega_sml .jl_fe_title' => 'color: {{VALUE}} !important;',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .sub-menu .jl_mega_gl .jl_fe_title a' => 'color: currentColor !important;',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .sub-menu .jl_mega_sml .jl_fe_title a' => 'color: currentColor !important;',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .jl_mega_gl .jl_post_meta span, .options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .jl_mega_gl .jl_post_meta span a' => 'color: {{VALUE}} !important;',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .jl_mega_sml .jl_post_meta span, .options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .jl_mega_sml .jl_post_meta span a' => 'color: {{VALUE}} !important;',                                
                            ],
                        ]
                    );

                    $this->add_control(
                        'sub_menu_hover_color',
                        [
                            'label'     => esc_html__( 'Color hover', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu .menu-item:hover > a' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_control(
                        'sub_menu_hover_color_dark',
                        [
                            'label'     => esc_html__( 'Color hover dark mode', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu .sub-menu .menu-item:hover > a' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_control(
                        'sub_menu_div_color',
                        [
                            'label'     => esc_html__( 'Divider line Color', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item.menu-item-has-children > .jl-cus-mega-menu.sub-menu .jl_mega_c_wrap, {{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item .jl-cus-mega-menu .jl_mega_inner > .jl_mega_contents + ul.sub-menu li' => 'border-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .pagination-nextprev .jl-foot-nav' => 'border-color: {{VALUE}} !important;',
                            ],
                        ]
                    );

                    $this->add_control(
                        'sub_menu_div_color_dark',
                        [
                            'label'     => esc_html__( 'Divider line Color dark mode', 'wesper' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item.menu-item-has-children > .jl-cus-mega-menu.sub-menu .jl_mega_c_wrap, .options_dark_skin {{WRAPPER}} .navigation_wrapper .jl_main_menu > .mega-category-menu.menu-item .jl-cus-mega-menu .jl_mega_inner > .jl_mega_contents + ul.sub-menu li' => 'border-color: {{VALUE}} !important;',
                                '.options_dark_skin {{WRAPPER}} .navigation_wrapper .mega-category-menu.menu-item .pagination-nextprev .jl-foot-nav' => 'border-color: {{VALUE}} !important;',
                            ],
                        ]
                    );

        $this->end_controls_section();        
    }
    protected function render( ) {
    include 'main-menu-setting.php';
    }
}