<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
defined('ABSPATH') || die();

class wesper_section_logo extends Widget_Base {

    public function get_name() {
        return 'wesper-section-logo';
    }

    public function get_title() {
        return esc_html__( 'Logo', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-logo jl-icons';
    }

    public function get_categories() {
        return [ 'wesper-elements-head' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_style_marker',
            [
                'label' => __( 'Logo Settings', 'wesper' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'logo_n',
            [
                'label' => esc_html__( 'Logo normal', 'wesper' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'logo_w',
            [
                'label' => esc_html__( 'Logo dark mode', 'wesper' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );        

        $this->add_responsive_control(
            'jl_logo_size',
            [
                'label' => __( 'Logo size', 'wesper' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                ],
                'default' => [
                    'size' => '250',
                    'unit' => 'px'
                ],
                'selectors' => [
                    '{{WRAPPER}} .logo_small_wrapper_table .logo_small_wrapper .logo_link img' => 'max-width: {{SIZE}}px !important',                    
                ],
            ]
        );     
        
        $this->add_responsive_control(
            'logo_align',
            array(
                'label'     => __( 'Alignment', 'wesper' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => array(
                    'left'   => array(
                        'title' => __( 'Left', 'wesper' ),
                        'icon'  => 'eicon-text-align-left',
                    ),
                    'center' => array(
                        'title' => __( 'Center', 'wesper' ),
                        'icon'  => 'eicon-text-align-center',
                    ),
                    'flex-end'  => array(
                        'title' => __( 'Right', 'wesper' ),
                        'icon'  => 'eicon-text-align-right',
                    ),
                ),
                'toggle'    => false,
                'default'   => 'left',
                'selectors' => array(
                    '{{WRAPPER}} .logo_small_wrapper_table' => 'justify-content: {{VALUE}};',
                )                
            )
        );

        $this->add_control(
            'logo_link',
            [
                'label' =>esc_html__( 'Logo custom URL', 'wesper' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,                                
            ]
        );

        $this->end_controls_section();        
    }
    protected function render( ) {
       $settings = $this->get_settings_for_display();
       $logo_tag = (is_front_page() ? 'h1' : 'span');
        ?>
                        <div class="logo_small_wrapper_table">
                            <div class="logo_small_wrapper">
                            <?php if ( ! empty( $settings['logo_link']['url'] ) ) {
                            $this->add_render_attribute( 'logo_link', 'class', 'logo_link', true );
                            $this->add_link_attributes( 'logo_link', $settings['logo_link'] ); ?>
                                <a <?php echo $this->get_render_attribute_string( 'logo_link' ); ?>>
                            <?php }else{?>                                                                                    
                                <a class="logo_link" href="<?php echo esc_url(home_url('/')); ?>">
                            <?php }?>
                                <<?php echo esc_html($logo_tag); ?>>
                                <?php if( !empty($settings['logo_n']['url']) ){?>
                                    <img class="jl_logo_n" src="<?php echo esc_url($settings['logo_n']['url']); ?>" alt="<?php bloginfo('description'); ?>" />                                    
                                <?php }?>
                                <?php if( !empty($settings['logo_w']['url']) ){?>
                                    <img class="jl_logo_w" src="<?php echo esc_url($settings['logo_w']['url']); ?>" alt="<?php bloginfo('description'); ?>" />
                                <?php } ?>                                
                                </<?php echo esc_html($logo_tag); ?>>
                            </a>
                            </div>
                        </div>   
        <?php
    }
}