<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class wesper_section_infobox extends Widget_Base {

    public function get_name() {
        return 'wesper-infobox';
    }

    public function get_title() {
        return esc_html__( 'Jelly Info Box', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-icon-box jl-icons';
    }    

    public function get_style_depends() {
       return [ 'jl-infobox' ];
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {
    
    $jl_primary_color = get_option( 'jl_primary_color_option', '#000' );
        
        /*
        * Infobox Image
        */
        $this->start_controls_section(
            'jl_section_infobox_content',
            [
                'label' => esc_html__( 'Content', 'wesper' )
            ]
        );

        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
            'jl_infobox_img_or_icon',
            [
                'label'         => esc_html__( 'Image or Icon', 'wesper' ),
                'type'          => Controls_Manager::CHOOSE,
                'toggle'        => false,
                'label_block'   => true,
                'default'       => 'icon',
                'options'       => [
                    'none'      => [
                        'title' => esc_html__( 'None', 'wesper' ),
                        'icon'  => 'eicon-ban'
                    ],
                    'icon'      => [
                        'title' => esc_html__( 'Icon', 'wesper' ),
                        'icon'  => 'eicon-info-circle'
                    ],
                    'img'       => [
                        'title' => esc_html__( 'Image', 'wesper' ),
                        'icon'  => 'eicon-image-bold'
                    ]
                ]
            ]
        );
        
        $repeater->add_control(
            'jl_infobox_image',
            [
                'label'     => esc_html__( 'Image', 'wesper' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url'   => Utils::get_placeholder_image_src()
                ],                
                'condition' => [
                    'jl_infobox_img_or_icon' => 'img'
                ]
            ]
        );
        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail',
                'default'   => 'medium_large',
                'condition' => [
                    'jl_infobox_img_or_icon' => 'img'
                ]
            ]
        );

        $repeater->add_control(
            'jl_infobox_icon',
            [
                'label'       => esc_html__( 'Icon', 'wesper' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-tag',
                    'library' => 'fa-solid'
                ],
                'condition'   => [
                    'jl_infobox_img_or_icon' => 'icon'
                ]
            ]
        );

        
        $repeater->add_control(
            'jl_infobox_title',
            [
                'label'       => esc_html__( 'Title', 'wesper' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__( 'Infobox Title', 'wesper' )                
            ]
        );

        $repeater->add_control(
            'jl_infobox_title_link',
            [
                'label'       => __( 'Link URL', 'wesper' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'wesper' ),
                'label_block' => true
            ]
        );

        $repeater->add_control(
            'jlc_info_button',
            array(
                'label'       => __( 'Button Text', 'wesper' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,                
            )
        );
        
        $repeater->add_control(
            'jl_infobox_description',
            [
                'label'   => esc_html__( 'Description', 'wesper' ),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'We work intimately with customers from around the world with quality', 'wesper' )                
            ]
        );

        $this->add_control(
                'infobox_items',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        ['jl_infobox_title' => 'Data Analytics'],
                        ['jl_infobox_title' => 'Perfect Fund'],
                        ['jl_infobox_title' => 'Quality Design'],
                        ['jl_infobox_title' => 'Training Course']                        
                    ],
                    'title_field' => '{{{ jl_infobox_title }}}',
                ]
            );     

        $this->end_controls_section();

        $this->start_controls_section( 'icon_svg_animate_section', [
            'label'     => esc_html__( 'Icon SVG Animate Stroke', 'wesper' ),
            'condition'   => [
                    'jl_infobox_anim' => 'true'
                ]
        ] );

        $this->add_control( 'icon_svg_animate', [
            'label' => esc_html__( 'SVG Animate', 'wesper' ),
            'type'  => Controls_Manager::SWITCHER,
        ] );

        $this->add_control( 'icon_svg_animate_play_on_hover', [
            'label' => esc_html__( 'Play on hover', 'wesper' ),
            'type'  => Controls_Manager::SWITCHER,
        ] );

        $this->add_control( 'icon_svg_animate_type', [
            'label'   => esc_html__( 'Type', 'wesper' ),
            'type'    => Controls_Manager::SELECT,
            'options' => [
                'delayed'  => esc_html__( 'Delayed', 'wesper' ),
                'sync'     => esc_html__( 'Sync', 'wesper' ),
                'oneByOne' => esc_html__( 'One By One', 'wesper' ),
            ],
            'default' => 'delayed',
        ] );

        $this->add_control( 'icon_svg_animate_duration', [
            'label'   => esc_html__( 'Transition Duration', 'wesper' ),
            'type'    => Controls_Manager::NUMBER,
            'default' => 120,
        ] );

        $this->end_controls_section();
        

        /*
        * Infobox Styling Section
        */
        $this->start_controls_section(
            'jl_section_infobox_styles_preset',
            [
                'label' => esc_html__( 'Container', 'wesper' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        
        $this->add_responsive_control(
                'item_num_col',
                [
                    'label' => esc_html__( 'Columns', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 12,
                            'step' => 1,
                        ]                        
                    ],                    
                    'default' => [
                        'size' => 4,
                        'unit' => 'px',
                    ],
                    'tablet_default' => [
                        'size' => 2,
                        'unit' => 'px',
                    ],
                    'mobile_default' => [
                        'size' => 1,
                        'unit' => 'px',
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .jl-infobox-wrapp' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr))',
                    ],
                ]
            );

            $this->add_responsive_control(
                'item_column_gap',
                [
                    'label' => esc_html__( 'Column Gap', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 200,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 30,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .jl-infobox-wrapp' => 'grid-column-gap: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'item_row_gap',
                [
                    'label' => esc_html__( 'Row Gap', 'wesper' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 200,
                            'step' => 1,
                        ]                        
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 30,
                    ],                    
                    'selectors' => [
                        '{{WRAPPER}} .jl-infobox-wrapp' => 'grid-row-gap: {{SIZE}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
            'jl_infobox_container_min_height',
            [
                'label'       => esc_html__( 'Min Height', 'wesper' ),
                'type'        => Controls_Manager::SLIDER,
                'range'       => [
                    'px'      => [
                        'max' => 100
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],                    
                'selectors'   => [
                    '{{WRAPPER}} .jl-infobox .jl-infobox-item' => 'min-height: {{SIZE}}%;',
                ],
            ]
        );

        $this->add_responsive_control(
            'jl_infobox_alignment',
            [
                'label'   => __( 'Alignment', 'wesper' ),
                'type'    => Controls_Manager::CHOOSE,
                'toggle'  => false,
                'options' => [
                    'jl-infobox-align-left'   => [
                        'title' => __( 'Left', 'wesper' ),
                        'icon'  => 'eicon-text-align-left'
                    ],
                    'jl-infobox-align-center' => [
                        'title' => __( 'Center', 'wesper' ),
                        'icon'  => 'eicon-text-align-center'
                    ],
                    'jl-infobox-align-right'  => [
                        'title' => __( 'Right', 'wesper' ),
                        'icon'  => 'eicon-text-align-right'
                    ]
                ],
                'default' => 'jl-infobox-align-center'
            ]
        );
        
        $this->add_responsive_control(
            'jl_infobox_padding',
            [
                'label'      => esc_html__( 'Padding', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],                
                'selectors'  => [
                    '{{WRAPPER}} .jl-infobox-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_infobox_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],                
                'selectors'  => [
                    '{{WRAPPER}} .jl-infobox-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'jl_infobox_container_tabs' );

            $this->start_controls_tab( 'jl_infobox_container_normal', [ 'label' => esc_html__( 'Normal', 'wesper' ) ] );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'      => 'jl_infobox_background_normal',
                        'types'     => [ 'classic', 'gradient' ],
                        'selector'  => '{{WRAPPER}} .jl-infobox .jl-infobox-item',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'jl_infobox_border_normal',
                        'selector' => '{{WRAPPER}} .jl-infobox-item'
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'     => 'jl_infobox_box_shadow_normal',
                        'selector' => '{{WRAPPER}} .jl-infobox-item'
                    ]
                );

            $this->end_controls_tab();
            $this->start_controls_tab( 'jl_infobox_container_hover', [ 'label' => esc_html__( 'Hover', 'wesper' ) ] );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name'      => 'jl_infobox_background_hover',
                        'types'     => [ 'classic', 'gradient' ],
                        'separator' => 'before',
                        'selector'  => '{{WRAPPER}} .jl-infobox .jl-infobox-item:before',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'jl_infobox_border_hover',
                        'selector' => '{{WRAPPER}} .jl-infobox-item:hover'
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'     => 'jl_infobox_box_shadow_hover',
                        'selector' => '{{WRAPPER}} .jl-infobox-item:hover'
                    ]
                );

            $this->end_controls_tab();
        
        $this->end_controls_tabs(); 

        
        $this->end_controls_section();

        // transition style

        $this->start_controls_section(
            'section_infobox_transition_style',
            [
                'label' => __('Transition', 'wesper'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'jl_infobox_transition_top',
            [
                'label'        => __( 'Transition Top', 'wesper' ),
                'type'         =>  Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'wesper' ),
                'label_off'    => __( 'Hide', 'wesper' ),
                'return_value' => 'yes',
                'default'      => 'yes'
            ]
        );        

        $this->end_controls_section();

        //icon style
        $this->start_controls_section(
            'section_infobox_icon',
            [
                'label' => __('Icon/Image', 'wesper'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'jl_infobox_icon_position',
            [
                'label'   => __( 'Position', 'wesper' ),
                'type'    => Controls_Manager::CHOOSE,
                'toggle'  => false,
                'options' => [
                    'jl-infobox-icon-position-left'   => [
                        'title' => __( 'Left', 'wesper' ),
                        'icon'  => 'eicon-arrow-left'
                    ],
                    'jl-infobox-icon-position-center' => [
                        'title' => __( 'Top', 'wesper' ),
                        'icon'  => 'eicon-arrow-up'
                    ],
                    'jl-infobox-icon-position-right'  => [
                        'title' => __( 'Right', 'wesper' ),
                        'icon'  => 'eicon-arrow-right'
                    ]
                ],
                'default' => 'jl-infobox-icon-position-center'
            ]
        );

        $this->add_control(
            'vertical_align',
            array(
              'label'       => esc_html__( 'Vertical align', 'wesper' ),
              'type'        => Controls_Manager::SELECT,
              'options'   => [
                              'flex-start'               => esc_html__( 'Top', 'wesper' ),
                              'center'        => esc_html__( 'Middle', 'wesper' ),
                              'flex-end'        => esc_html__( 'Bottom', 'wesper' )                              
                          ],
              'default'     => 'flex-start',
              'condition' => [
                'jl_infobox_icon_position'    => ['jl-infobox-icon-position-left','jl-infobox-icon-position-right']
              ],
              'selectors'   => [
                '{{WRAPPER}} .jl-infobox-icon-position-left, {{WRAPPER}} .jl-infobox-icon-position-right' => 'align-items: {{VALUE}}'
            ]
            )
          );    

          $this->add_responsive_control(
            'jl_infobox_align_list',
            [
                'label'   => __( 'List box position', 'wesper' ),
                'type'    => Controls_Manager::CHOOSE,
                'toggle'  => false,
                'options' => [                    
                    'column' => [
                        'title' => __( 'Block', 'wesper' ),
                        'icon'  => 'eicon-arrow-up'
                    ],
                    'row'  => [
                        'title' => __( 'Inline', 'wesper' ),
                        'icon'  => 'eicon-arrow-right'
                    ]
                ],
                'condition' => [
                    'jl_infobox_icon_position'    => ['jl-infobox-icon-position-left','jl-infobox-icon-position-right']
                ],
                'selectors'   => [
                    '{{WRAPPER}} .jl-infobox-icon-position-left, {{WRAPPER}} .jl-infobox-icon-position-right' => 'flex-direction: {{VALUE}}',                    
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_infobox_list_alignment',
            [
                'label'   => __( 'Alignment', 'wesper' ),
                'type'    => Controls_Manager::CHOOSE,
                'toggle'  => false,
                'options' => [
                    'left'   => [
                        'title' => __( 'Left', 'wesper' ),
                        'icon'  => 'eicon-text-align-left'
                    ],
                    'center' => [
                        'title' => __( 'Center', 'wesper' ),
                        'icon'  => 'eicon-text-align-center'
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'wesper' ),
                        'icon'  => 'eicon-text-align-right'
                    ]
                ],
                'default' => 'center',
                'selectors'   => [
                    '{{WRAPPER}} .jl-infobox .jl-infobox-item .jl-infobox-content' => 'text-align: {{VALUE}};'
                ],
                'condition' => [
                    'jl_infobox_align_list'    => ['column']
                ]
            ]
        );

        $this->add_control(
            'jl_infobox_enable_box',
            [
                'label'        => __( 'Enable Box', 'wesper' ),
                'type'         =>  Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'wesper' ),
                'label_off'    => __( 'Hide', 'wesper' ),
                'return_value' => 'yes',
                'default'      => 'yes'
            ]
        );

        $this->add_responsive_control(
            'jl_infobox_icon_height',
            [
                'label'       => esc_html__( 'Height', 'wesper' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 80
                ],
                'range'       => [
                    'px'      => [
                        'max' => 250
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon' => 'height: {{SIZE}}px;'
                ],
                'condition' => [
                    'jl_infobox_enable_box' => 'yes' 
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_infobox_icon_width',
            [
                'label'       => esc_html__( 'Width', 'wesper' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 80
                ],
                'range'       => [
                    'px'      => [
                        'max' => 250
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon' => 'width: {{SIZE}}px;',
                    '{{WRAPPER}} .jl-infobox-icon-position-left .jl-infobox-content' => 'flex-basis: calc( 100% - {{SIZE}}px );',
                    '{{WRAPPER}} .jl-infobox-icon-position-right .jl-infobox-content' => 'flex-basis: calc( 100% - {{SIZE}}px );'
                ],
                'condition' => [
                    'jl_infobox_enable_box' => 'yes' 
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_infobox_icon_font_size',
            [
                'label'       => esc_html__( 'Icon Size', 'wesper' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 35
                ],
                'range'       => [
                    'px'      => [
                        'max' => 250
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon i'   => 'font-size: {{SIZE}}px;',
                    '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon svg' => 'height: {{SIZE}}px; width: auto;'
                ]                
            ]
        );

        $this->add_responsive_control(
            'jl_infobox_icon_image_size',
            [
                'label'       => esc_html__( 'Image Size', 'wesper' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 40
                ],
                'range'       => [
                    'px'      => [
                        'max' => 400
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon img' => 'height: {{SIZE}}px; width: auto !important;'
                ],                
            ]
        );

        $this->add_responsive_control(
            'jl_infobox_icon_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],                
                'selectors'  => [
                    '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'jl_infobox_icon_box_shadow',
                'selector' => '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon'
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'jl_infobox_image_css_filter',
                'selector' => '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon img',                
            ]
        );        

        $this->add_responsive_control(
            'jl_infobox_icons_margin',
            [
                'label'      => __( 'Spacing icons', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],
                'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '10',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'jl_infobox_icon_tabs' );
            // Normal State Tab
            $this->start_controls_tab( 'jl_infobox_icon_normal', [ 'label' => esc_html__( 'Normal', 'wesper' ) ] );

                $this->add_control(
                    'jl_infobox_icon_background_color_normal',
                    [
                        'label'     => esc_html__( 'Background', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#000',
                        'default'   => $jl_primary_color,
                        'selectors' => [
                            '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon' => 'background: {{VALUE}}'
                        ]
                    ]
                );

                $this->add_control(
                    'jl_infobox_icon_color_normal',
                    [
                        'label'     => esc_html__( 'Icon Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon i' => 'color: {{VALUE}}',                            
                        ],                        
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'jl_infobox_icon_border_normal',
                        'selector' => '{{WRAPPER}} .jl-infobox-item .jl-infobox-icon'
                    ]
                );

            $this->end_controls_tab();

            // Hover State Tab
            $this->start_controls_tab( 'jl_infobox_icon_hover', [ 'label' => esc_html__( 'Hover', 'wesper' ) ] );

                $this->add_control(
                    'jl_infobox_icon_background_color_hover',
                    [
                        'label'     => esc_html__( 'Background', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .jl-infobox-item:hover .jl-infobox-icon' => 'background: {{VALUE}}'
                        ]
                    ]
                );

                $this->add_control(
                    'jl_infobox_icon_color_hover',
                    [
                        'label'     => esc_html__( 'Icon Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => $jl_primary_color,
                        'selectors' => [
                            '{{WRAPPER}} .jl-infobox-item:hover .jl-infobox-icon i' => 'color: {{VALUE}}',                            
                        ],                        
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'jl_infobox_icon_border_hover',
                        'selector' => '{{WRAPPER}} .jl-infobox-item:hover .jl-infobox-icon'
                    ]
                );
                
            $this->end_controls_tab();
        $this->end_controls_tabs();
        
        $this->end_controls_section();

        // Title , Description Font Color and Typography

        $this->start_controls_section(
            'section_infobox_title',
            [
                'label' => __('Title', 'wesper'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'infobox_title_typography',
                'selector' => '{{WRAPPER}} .jl-infobox-content-title',
                'fields_options'   => [
                    'font_size'    => [
                        'default'  => [
                            'unit' => 'px',
                            'size' => 30
                        ]
                    ],
                    'font_weight'  => [
                        'default'  => '600'
                    ]
                ]
            ]
        );
        
        $this->add_responsive_control(
            'jl_infobox_title_margin',
            [
                'label'      => __( 'Margin', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],
                'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '10',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-infobox-content-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'jl_infobox_title_tabs' );

            $this->start_controls_tab( 'jl_infobox_title_normal', [ 'label' => esc_html__( 'Normal', 'wesper' ) ] );

                $this->add_control(
                    'jl_title_color_normal',
                    [
                        'label'     => __('Color', 'wesper'),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#000000',
                        'selectors' => [
                            '{{WRAPPER}} .jl-infobox-content-title' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
            $this->start_controls_tab( 'jl_infobox_title_hover', [ 'label' => esc_html__( 'Hover', 'wesper' ) ] );

                $this->add_control(
                    'jl_title_color_hover',
                    [
                        'label'     => esc_html__( 'Title Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                              '{{WRAPPER}} .jl-infobox-item:hover .jl-infobox-content-title' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
        $this->end_controls_tabs(); 

        $this->end_controls_section();

        $this->start_controls_section(
            'section_infobox_description',
            [
                'label' => __('Description', 'wesper'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs( 'jl_infobox_desc_tabs' );

            $this->start_controls_tab( 'jl_infobox_desc_normal', [ 'label' => esc_html__( 'Normal', 'wesper' ) ] );

                $this->add_control(
                    'jl_desc_color_normal',
                    [
                        'label'     => __('Description Color', 'wesper'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .jl-infobox-content-description' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
            $this->start_controls_tab( 'jl_infobox_desc_hover', [ 'label' => esc_html__( 'Hover', 'wesper' ) ] );

                $this->add_control(
                    'jl_desc_color_hover',
                    [
                        'label'     => esc_html__( 'Description Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                              '{{WRAPPER}} .jl-infobox-item:hover .jl-infobox-content-description' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
        $this->end_controls_tabs(); 

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'jl_description_typography',
                'selector' => '{{WRAPPER}} .jl-infobox-content-description'
            ]
        );
        
        $this->add_responsive_control(
            'jl_infobox_description_margin',
            [
                'label'      => __( 'Margin', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .jl-infobox-content-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();
        
        /*
        * Infobox Animating Mask
        */
        
        $this->start_controls_section(
            'jl_section_infobox_button',
            [
                'label'     => esc_html__( 'Button text', 'wesper' ),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
       $this->start_controls_tabs( 'jl_infobox_button_tabs' );

            $this->start_controls_tab( 'jl_infobox_button_normal', [ 'label' => esc_html__( 'Normal', 'wesper' ) ] );

                $this->add_control(
                    'jl_button_color_normal',
                    [
                        'label'     => __('Button Color', 'wesper'),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .jl-infobox-btn' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
            $this->start_controls_tab( 'jl_infobox_button_hover', [ 'label' => esc_html__( 'Hover', 'wesper' ) ] );

                $this->add_control(
                    'jl_button_color_hover',
                    [
                        'label'     => esc_html__( 'Button Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                              '{{WRAPPER}} .jl-infobox-item:hover .jl-infobox-btn' => 'color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        
        $this->end_controls_tabs(); 

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'jlbutton__typography',
                'selector' => '{{WRAPPER}} .jl-infobox-btn'
            ]
        );
        
        $this->add_responsive_control(
            'jl_infoboxbutton__margin',
            [
                'label'      => __( 'Margin', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%'],                
                'selectors'  => [
                    '{{WRAPPER}} .jl-infobox-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();

    }
    protected function render( ) {
       
       $settings                  = $this->get_settings_for_display();      
       $infobox_items    = $this->get_settings_for_display('infobox_items');

        if ( ! empty( $settings['icon_svg_animate'] ) && 'yes' === $settings['icon_svg_animate'] ) {
            $vivus_settings = [
                'enable'        => $settings['icon_svg_animate'],
                'type'          => $settings['icon_svg_animate_type'],
                'duration'      => $settings['icon_svg_animate_duration'],
                'play_on_hover' => $settings['icon_svg_animate_play_on_hover'],
            ];
            $this->add_render_attribute( 'animation_wrap', 'data-vivus', wp_json_encode( $vivus_settings ) );
        }

        $this->add_render_attribute( 'jl_infobox_transition',[
            'class' => [
                'jl-infobox-item', 
                esc_attr( $settings['jl_infobox_alignment'] ), 
                esc_attr( $settings['jl_infobox_icon_position'] ),
                'jl-infobox-enable-box-'.esc_attr( $settings['jl_infobox_enable_box'] )
            ]
        ]);

        if( 'yes' === $settings['jl_infobox_transition_top'] ){
            $this->add_render_attribute( 'jl_infobox_transition', 'class', 'simple-transition' );
        }                
        ?>
        <div class="jl-infobox-wrapp">
        <?php
        foreach ( $infobox_items as $index => $list ):
        $icons_svg = isset( $list['jl_infobox_icon']['library'] ) && 'svg' === $list['jl_infobox_icon']['library'] ? true : false;    
        $title = $list['jl_infobox_title'];
        $details = $list['jl_infobox_description'];
        $jlc_info_button = $list['jlc_info_button'];        
        ?>        
        <div class="jl-infobox">
            <div <?php echo $this->get_render_attribute_string( 'jl_infobox_transition' );?> <?php echo $this->get_render_attribute_string( 'animation_wrap' );?>>
                <?php if( 'none' !== $list['jl_infobox_img_or_icon'] ) { ?>
                    <div class="jl-infobox-icon<?php if($icons_svg){echo ' jl-svg-icon';} ?>">
                        <?php if( 'icon' === $list['jl_infobox_img_or_icon'] && $list['jl_infobox_icon']['value'] ) : ?>
                            <?php Icons_Manager::render_icon( $list['jl_infobox_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        <?php endif; ?>

                        <?php if( 'img' === $list['jl_infobox_img_or_icon'] ) :
                            echo Group_Control_Image_Size::get_attachment_image_html( $list, 'thumbnail', 'jl_infobox_image' );
                        endif; ?>   
                    </div>
                <?php } ?>
                <div class="jl-infobox-content">                    
                    <?php $title ? printf( '<h3 class="jl-infobox-content-title">%s</h3>', $title ) : ''; ?>
                    <?php $details ? printf( '<div class="jl-infobox-content-description">%s</div>', wp_kses_post( $details ) ) : ''; ?>
                    <?php $jlc_info_button ? printf( '<div class="jl-infobox-btn"><span>%s</span></div>', $jlc_info_button ) : ''; ?>
                </div>
                <?php 
                $link_key = 'link_' . $index;
                $jl_infobox_title_link = $list['jl_infobox_title_link']['url'];
                if( $jl_infobox_title_link ) {
                        $this->add_render_attribute( $link_key, 'href', esc_url( $jl_infobox_title_link ) );
                        if( $list['jl_infobox_title_link']['is_external'] ) {
                        $this->add_render_attribute( $link_key, 'target', '_blank' );
                        }
                        if( $list['jl_infobox_title_link']['nofollow'] ) {
                        $this->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                ?>
                <a class="jl_info_link" <?php echo $this->get_render_attribute_string( $link_key ) ;?>></a>
                <?php } ?>
            </div>            
        </div>
        <?php endforeach; ?>        
        </div>
        <?php        
    }
}