<?php
namespace wesperElementor;
use Elementor\Widget_Base;
defined('ABSPATH') || die();
define("WESPER_API", 'https://jellywp.com/wp/wp-json/purchase/v1/purchase-check');
define("WESPER_ID", 25223481);
define("WESPER_THEMENAME", 'Welcome to Wesper');
if (!did_action('elementor/loaded')) {
	return;
}

class wesper_Shortcode{
    
    private static $_instance = null;
    public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
	public function __construct(){
        add_action('elementor/elements/categories_registered', array($this, 'wesper_header_ele_init'));
        add_action('elementor/elements/categories_registered', array($this, 'wesper_elementor_init'), 10, 1);        
        add_action( 'elementor/widgets/register', array( $this, 'wesper_shortcode_elements' ), 1 );        
        add_action( 'elementor/element/section/section_background/after_section_end', [ $this, 'wesper_bg_dark' ], 10, 2 );
        add_action( 'elementor/element/section/section_border/after_section_end', [ $this, 'wesper_border_dark' ], 10, 2 );
        add_action( 'elementor/element/column/section_advanced/after_section_end', [ $this, 'wesper_order' ], 10, 2 );
        add_action( 'elementor/element/common/_section_style/after_section_end', array( $this, 'wesper_order' ), 10, 2 );                
        add_action( 'elementor/element/divider/section_divider_style/after_section_end', array( $this, 'wesper_dark_input' ), 10, 2 );        
        add_action( 'elementor/element/heading/section_title_style/after_section_end', array( $this, 'wesper_heading_dark' ), 10, 2 );
        add_action( 'elementor/element/image-box/section_style_content/after_section_end', array( $this, 'wesper_image_box_dark' ), 10, 2 );
        add_action( 'elementor/element/counter/section_title/after_section_end', array( $this, 'wesper_counter_dark' ), 10, 2 );
        add_action( 'elementor/element/icon-box/section_style_content/after_section_end', array( $this, 'wesper_icon_box_dark' ), 10, 2 );        
        add_action( 'elementor/element/text-editor/section_style/after_section_end', array( $this, 'wesper_editor_dark' ), 10, 2 );        
        add_action( 'elementor/element/social-icons/section_social_hover/after_section_end', array( $this, 'wesper_social_icons_dark' ), 10, 2 );        
        add_action( 'elementor/element/icon/section_style_icon/after_section_end', array( $this, 'wesper_icons_dark' ), 10, 2 );        
        add_action( 'elementor/element/icon-list/section_text_style/after_section_end', array( $this, 'wesper_icons_list_dark' ), 10, 2 );        
        add_action( 'elementor/element/button/section_style/after_section_end', array( $this, 'wesper_button_dark' ), 10, 2 );                        
        add_action( 'elementor/frontend/after_register_scripts', array( $this, 'wesper_after_register_scripts' ) );
        add_action( 'elementor/frontend/after_enqueue_styles', array( $this, 'wesper_after_register_styles' ) );
	}
    public function wesper_after_register_scripts(){
        wp_register_script('opt-mod', WESPER_ADDONS_ASSETS . 'js/opt-mod.js', array( 'jquery' ),false,true);
    }
    public function wesper_after_register_styles() {
          wp_register_style('jl-infobox', WESPER_ADDONS_ASSETS .'css/infobox.css', false, false, 'all' );
          wp_register_style('jl-accordion', WESPER_ADDONS_ASSETS .'css/accordion.css', false, false, 'all' );      
    }
    public function wesper_header_ele_init($elements_manager){
        $categories = [];
        $categories['wesper-elements-head'] = [
            'title' => esc_html__( 'Wesper header elements', 'wesper' ),
            'icon' => 'fa fa-server',
        ];
        $old_categories = $elements_manager->get_categories();
        $categories = array_merge($categories, $old_categories);
        $set_categories = function ( $categories ) {
            $this->categories = $categories;
        };
        $set_categories->call( $elements_manager, $categories );
    }

    public function wesper_elementor_init($elements_manager){
        $categories = [];
        $categories['wesper-elements'] = [
            'title' => esc_html__( 'Wesper blog layouts', 'wesper' ),
            'icon' => 'fa fa-server',
        ];
        $old_categories = $elements_manager->get_categories();
        $categories = array_merge($categories, $old_categories);
        $set_categories = function ( $categories ) {
            $this->categories = $categories;
        };
        $set_categories->call( $elements_manager, $categories );
    }    
    public function wesper_shortcode_elements(){
        $wesper_is_registered = false;
        $wesper_is_registered = wesper_is_registered();
        if(empty($wesper_is_registered)){
            return;
        }
        require_once 'section-title.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_title());
        require_once 'feature-box.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_box());
        require_once 'featured-layout-1.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout1());
        require_once 'featured-layout-2.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout2());
        require_once 'featured-layout-19.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout19());
        require_once 'featured-layout-20.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout20());
        require_once 'featured-layout-3.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout3());
        require_once 'featured-layout-4.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout4());
        require_once 'featured-layout-5.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout5());
        require_once 'featured-layout-6.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout6());
        require_once 'featured-layout-7.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout7());
        require_once 'featured-layout-8.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout8());
        require_once 'featured-layout-9.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout9());
        require_once 'featured-layout-10.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout10());
        require_once 'featured-layout-11.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout11());
        require_once 'featured-layout-12.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout12());
        require_once 'featured-layout-13.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout13());
        require_once 'featured-layout-14.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout14());
        require_once 'featured-layout-18.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout18());
        require_once 'small-main-right-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout15());
        require_once 'small-main-below-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout16());
        require_once 'small-main-below-2list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout_ligrid());
        require_once 'small-2main-below-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_layout17());
        require_once 'small-overlay-main-below-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_main_ov_sm_li());
        require_once 'feature-slider.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_slider());
        require_once 'feature-slider-tab.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_slider_tab());
        require_once 'feature-hover.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_hover());
        require_once 'feature-carousel.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_carousel());
        require_once 'feature-center-slider.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_center_slider());
        require_once 'large-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_large_post());
        require_once 'grid-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_grid_post());
        require_once 'grid-number.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_grid_number());
        require_once 'grid-overlay.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_grid_overlay());
        require_once 'list-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_list_post());
        require_once 'list-mix-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_list_mix_post());
        require_once 'list-number.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_list_number());
        require_once 'small-list-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_small_list());
        require_once 'xsmall-list-post.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_xsmall_list());
        require_once 'contact-form.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_contact_form());
        require_once 'gallery.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_gallery());
        require_once 'category-list.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_category_list());
        require_once 'social.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_social_list());
        require_once 'feature-video.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_feature_video());
        require_once 'marquee-text.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_marquee_text());
        require_once 'newsticker.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_newsticker_text());      

        if ( class_exists( 'woocommerce' ) ) {
            require_once 'feature-product.php';
            \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_product_list());
            require_once 'cart.php';
            \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_cart());
        }

        require_once 'logo.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_logo());
        require_once 'simple-menu.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_simple_menu());
        require_once 'search-button.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_search_button());
        require_once 'mobile-menu.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_mobile_menu());      
        require_once 'dark-mode-switcher.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_dark_mode());
        require_once 'main-menu.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_main_menu());
        require_once 'current-date.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_current_date());
        require_once 'layouts.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_layouts());

        require_once 'accordion.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_accordion());
        require_once 'infobox.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new Widgets\wesper_section_infobox());
      
    }
    public function wesper_bg_dark( $element, $args ) {
        $element->start_controls_section(
                'wesper_bg_dark_section',
                [
                    'label' => esc_html__( 'Dark Mode Background Options', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );
        $element->add_group_control(
            \Elementor\Group_Control_Background::get_type(), array(
                'label'    => esc_html__( 'Dark Mode Background', 'wesper' ),
                'name'     => 'wesper_bg_dark',
                'types'    => array( 'classic', 'gradient' ),
                'selector' => '.options_dark_skin {{WRAPPER}}.elementor-section',
            )
        );
        $element->end_controls_section();
    }
    public function wesper_border_dark( $element, $args ) {
        $element->start_controls_section(
                'jl_border_section',
                [
                    'label' => esc_html__( 'Dark Mode Border Options', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                ]
        );
        $element->add_control(
                'jl_border_dk_color',
                [
                    'label' => esc_html__( 'Dark Mode Border Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}' => 'border-color: {{VALUE}}',
                    )
                ]
        );
        $element->add_control(
                'jl_border_dk_hover',
                [
                    'label' => esc_html__( 'Dark Mode Border Hover Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}:hover' => 'border-color: {{VALUE}}',
                    )
                ]
        );
        $element->end_controls_section();
    }
    public function wesper_order( $element, $args ) {
            $element->start_controls_section(
                'wesper_jl_order_section',
                [
                    'label' => esc_html__( 'Custom Order', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
                ]
            );
            $element->add_responsive_control(
                'wesper_jl_order',
                [
                    'label'     => __( 'Order', 'wesper' ),
                    'type'      => \Elementor\Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}}' => 'order: {{VALUE}};',
                    ]
                ]
            );
            $element->end_controls_section();
    }
    public static function wesper_dark_input( $element, $args ) {
        $element->start_controls_section(
            'jl_svg_dark', array(
                'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        $element->add_control(
            'jl_svg_color_dark', array(
                'label'       => esc_html__( 'Color', 'wesper' ),
                'type'        => \Elementor\Controls_Manager::COLOR,
                'selectors'   => array( '.options_dark_skin {{WRAPPER}}' => '--divider-color: {{VALUE}}', ),
                'default'     => ''
            )
        );
        $element->end_controls_section();
    }

    public static function wesper_heading_dark( $element, $args ) {
            $element->start_controls_section(
                'jl_title_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'jl_dark_title_color', array(
                    'label'       => esc_html__( 'Dark Mode Text Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-heading-title' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->end_controls_section();
    }    

    public static function wesper_image_box_dark( $element, $args ) {
            $element->start_controls_section(
                'jl_img_box_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'jl_dark_title_color', array(
                    'label'       => esc_html__( 'Title Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-image-box-title' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
    
            $element->add_control(
                'jl_dark_desc_color', array(
                    'label'       => esc_html__( 'Description Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-image-box-description' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#eeeeee'
                )
            );
            $element->end_controls_section();
        }

    public static function wesper_counter_dark( $element, $args ) {
            $element->start_controls_section(
                'jl_counter_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'jl_dark_number_color',
                array(
                    'label'     => esc_html__( 'Number Color', 'wesper' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-counter-number-wrapper' => 'color: {{VALUE}};',
                    )
                )
            );
            $element->add_control(
                'jl_dark_title_color',
                array(
                    'label'     => esc_html__( 'Text Color', 'wesper' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-counter-title' => 'color: {{VALUE}};',
                    )
                )
            );
    
            $element->end_controls_section();
    }
        
    public static function wesper_icon_box_dark( $element, $args ) {
            $element->start_controls_section(
                'jl_icon_box_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'jl_dark_icon_color', array(
                    'label'       => esc_html__( 'Icon Primary Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon'                                                                        => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon, .options_dark_skin {{WRAPPER}}.elementor-view-default .elementor-icon' => 'fill: {{VALUE}}; color: {{VALUE}}; border-color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'jl_dark_icons_color', array(
                    'label'       => esc_html__( 'Icon Secondary Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon'  => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'fill: {{VALUE}}; color: {{VALUE}};'
                    ),
                    'default'     => ''
                )
            );
    
            $element->add_control(
                'jl_dark_hicon_color', array(
                    'label'       => esc_html__( 'Hover Icon Primary Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon:hover'                                                                              => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon:hover, .options_dark_skin {{WRAPPER}}.elementor-view-default .elementor-icon:hover' => 'fill: {{VALUE}}; color: {{VALUE}}; border-color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'jl_dark_hicons_color', array(
                    'label'       => esc_html__( 'Hover Icon Secondary Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon:hover'  => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon:hover' => 'fill: {{VALUE}}; color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'jl_dark_title_color', array(
                    'label'       => esc_html__( 'Title Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-box-title' => 'color: {{VALUE}};'
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->add_control(
                'jl_dark_desc_color', array(
                    'label'       => esc_html__( 'Description Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-box-description' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#eeeeee'
                )
            );
            $element->end_controls_section();
        }

        
        public static function wesper_editor_dark( $element, $args ) {
            $element->start_controls_section(
                'jl_editor_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'jl_dark_editor_color', array(
                    'label'       => esc_html__( 'Text Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} *' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->end_controls_section();
        }      

        
        public static function wesper_social_icons_dark( $element, $args ) {
            $element->start_controls_section(
                'jl_social_i_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'jl_dark_icon_primary_color',
                array(
                    'label'     => esc_html__( 'Primary Color', 'wesper' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon' => 'background-color: {{VALUE}};',
                    ),
                )
            );
            $element->add_control(
                'jl_dark_icon_secondary_color',
                array(
                    'label'     => esc_html__( 'Secondary Color', 'wesper' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon i'   => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon svg' => 'fill: {{VALUE}};',
                    ),
                )
            );
    
            $element->add_control(
                'jl_dark_hicon_primary_color',
                array(
                    'label'     => esc_html__( 'Hover Primary Color', 'wesper' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon:hover' => 'background-color: {{VALUE}};',
                    ),
                )
            );
            $element->add_control(
                'jl_dark_hicon_secondary_color',
                array(
                    'label'     => esc_html__( 'Hover Secondary Color', 'wesper' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon:hover i'   => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-social-icon:hover svg' => 'fill: {{VALUE}};',
                    ),
                )
            );
            $element->end_controls_section();
        }
        
        public static function wesper_icons_dark( $element, $args ) {
            $element->start_controls_section(
                'jl_icon_head_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'jl_dark_icon_color', array(
                    'label'       => esc_html__( 'Primary Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon, .options_dark_skin {{WRAPPER}}.elementor-view-default .elementor-icon' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon, .options_dark_skin {{WRAPPER}}.elementor-view-default .elementor-icon svg' => 'fill: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->add_control(
                'jl_dark_icons_color', array(
                    'label'       => esc_html__( 'Secondary Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}}.elementor-view-framed .elementor-icon' => 'background-color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon' => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}}.elementor-view-stacked .elementor-icon svg' => 'fill: {{VALUE}};',
                    ),
                    'default'     => '',
                    'condition'   => array( 'view!' => 'default', ),
                )
            );
            $element->end_controls_section();
        }

        public static function wesper_icons_list_dark( $element, $args ) {
            $element->start_controls_section(
                'jl_icons_list_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $element->add_control(
                'jl_dark_icon_color', array(
                    'label'       => esc_html__( 'Icon Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-icon i'   => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-icon svg' => 'fill: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->add_control(
                'jl_dark_hicon_color', array(
                    'label'       => esc_html__( 'Hover Icon Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-icon i'   => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-icon svg' => 'fill: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'jl_dark_text_color', array(
                    'label'       => esc_html__( 'Text Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-text' => 'color: {{VALUE}};',
                    ),
                    'default'     => '#ffffff'
                )
            );
            $element->add_control(
                'jl_dark_htext_color', array(
                    'label'       => esc_html__( 'Hover Text Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-text' => 'color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $element->add_control(
                'jl_dark_divider_color', array(
                    'label'       => esc_html__( 'Divider Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'condition'   => array( 'divider' => 'yes' ),
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-icon-list-item:not(:last-child):after' => 'border-color: {{VALUE}}',
                    ),
                    'default'     => '#cccccc'
                )
            );
            $element->end_controls_section();
        }
        
        public static function wesper_button_dark( $section, $args ) {
            $section->start_controls_section(
                'jl_button_dark_mode', array(
                    'label' => esc_html__( 'Dark Mode Settings', 'wesper' ),
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                )
            );
            $section->add_control(
                'jl_dark_button_text_color', array(
                    'label'       => esc_html__( 'Text Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button' => 'fill: {{VALUE}}; color: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $section->add_control(
                'jl_dark_button_bg_color', array(
                    'label'       => esc_html__( 'Background Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button' => 'background: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $section->add_control(
                'jl_dark_button_line_color', array(
                    'label'       => esc_html__( 'Border Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button' => 'border-color: {{VALUE}}',
                    ),
                    'default'     => ''
                )
            );
            $section->add_control(
                'jl_dark_button_text_colorh', array(
                    'label'       => esc_html__( 'Hover Text Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => [
                        '.options_dark_skin {{WRAPPER}} .elementor-button:hover, .options_dark_skin {{WRAPPER}} .elementor-button:focus'         => 'color: {{VALUE}};',
                        '.options_dark_skin {{WRAPPER}} .elementor-button:hover svg, .options_dark_skin {{WRAPPER}} .elementor-button:focus svg' => 'fill: {{VALUE}};',
                    ],
                    'default'     => ''
                )
            );
            $section->add_control(
                'jl_dark_button_bg_colorh', array(
                    'label'       => esc_html__( 'Hover Background Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button:hover, .options_dark_skin {{WRAPPER}} .elementor-button:focus' => 'background: {{VALUE}};',
                    ),
                    'default'     => ''
                )
            );
            $section->add_control(
                'jl_dark_button_line_colorh', array(
                    'label'       => esc_html__( 'Hover Border Color', 'wesper' ),
                    'type'        => \Elementor\Controls_Manager::COLOR,
                    'selectors'   => array(
                        '.options_dark_skin {{WRAPPER}} .elementor-button:hover, .options_dark_skin {{WRAPPER}} .elementor-button:focus' => 'border-color: {{VALUE}}',
                    ),
                    'default'     => ''
                )
            );
    
            $section->end_controls_section();
        }
        
    
}
wesper_Shortcode::instance();