<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class wesper_section_dark_mode extends Widget_Base {

    public function get_name() {
        return 'wesper-dark-mode-switch';
    }

    public function get_title() {
        return esc_html__( 'Dark mode switcher', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-circle jl-icons';
    }

    public function get_categories() {
        return [ 'wesper-elements-head' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_style_marker',
            [
                'label' => __( 'Dark Mode Style', 'wesper' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );          
        $this->add_control(
            'jl_btn_switch_color',
            [
                'label' =>esc_html__( 'Color', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .wesper_day_night .jl-night-toggle-icon' => 'background: {{VALUE}} !important;',
                ],
            ]
        );  

        $this->add_control(
            'jl_btn_switch_color_dark',
            [
                'label' =>esc_html__( 'Color dark mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .wesper_day_night .jl-night-toggle-icon' => 'background: {{VALUE}} !important;',
                ],
            ]
        );        

        $this->end_controls_section();        
    }
    protected function render( ) {
       $settings = $this->get_settings_for_display();
        ?>
        <div class="wesper_day_night <?php $jl_dn_option = isset( $_COOKIE['jlmode_dn'] ) ? $_COOKIE['jlmode_dn'] : '';if ( 'true' === $jl_dn_option ) {echo 'jl_night_en';}else{echo 'jl_day_en';}?>">
            <span class="jl-night-toggle-icon">
                <span class="jl_moon">
                    <i class="jli-moon"></i>
                </span>
                <span class="jl_sun">
                    <i class="jli-sun"></i>
                </span>
            </span>
        </div>
        <?php
    }
}