<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;
use Elementor\Icons_Manager;


defined('ABSPATH') || die();

class wesper_accordion extends Widget_Base {

    public function get_name() {
        return 'wesper-accordion';
    }

    public function get_title() {
        return esc_html__( 'Jelly Accordion', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-accordion jl-icons';
    }

    public function get_script_depends() {
        return array(
            'opt-mod',
        );
    }

    public function get_style_depends() {
       return [ 'jl-accordion' ];
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {
    
    $this->start_controls_section(
            'jl_section_accordion_content_settings',
            [
                'label' => esc_html__( 'Contents', 'wesper' )
            ]
        );

        $repeater = new Repeater();

        $repeater->start_controls_tabs('jl_accordion_item_tabs');

        $repeater->start_controls_tab('jl_accordion_item_content_tab', ['label' => __('Content', 'wesper')]);

        $repeater->add_control(
            'jl_accordion_default_active', [
                'label'        => esc_html__( 'Active as Default', 'wesper' ),
                'type'         => Controls_Manager::SWITCHER,
                'default'      => 'no',
                'return_value' => 'yes'
            ]
        );

        $repeater->add_control(
            'jl_accordion_icon_show', [
                'label'        => esc_html__( 'Enable Title Icon', 'wesper' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'wesper' ),
                'label_off'    => __( 'Off', 'wesper' ),
                'default'      => 'no',
                'return_value' => 'yes'
            ]
        );
        
        $repeater->add_control(
            'jl_accordion_title_icon',
            [
                'label'       => __( 'Icon', 'wesper' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'default'     => [
                    'value'   => 'far fa-user',
                    'library' => 'fa-regular'
                ],
                'condition'   => [
                    'jl_accordion_icon_show' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'jl_accordion_title', [
                'label'   => esc_html__( 'Title', 'wesper' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__( 'Accordion Title', 'wesper' )                
            ]
        );
        
        $repeater->add_control(
            'jl_accordion_content', [
                'label'   => esc_html__( 'Content', 'wesper' ),
                'type'    => Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Optio, neque qui velit. Magni dolorum quidem ipsam eligendi, totam, facilis laudantium cum accusamus ullam voluptatibus commodi numquam, error, est. Ea, consequatur.', 'wesper' )
            ]
        );

        $repeater->add_control(
            'jl_accordion_show_read_more_btn',
            [
                'label'        => esc_html__( 'Enable Button.', 'wesper' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'wesper' ),
                'label_off'    => __( 'Off', 'wesper' ),
                'default'      => 'no',
                'return_value' => 'yes',
                'separator'    => 'before'
            ]
        );  

        $repeater->add_control(
            'jl_accordion_read_more_btn_text',
            [   
                'label'       => esc_html__( 'Button Text', 'wesper' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('See Details', 'wesper'),
                'default'     => esc_html__('See Details', 'wesper' ),
                'condition'   => [
                    '.jl_accordion_show_read_more_btn' => 'yes'
                ]                
            ]
        );

        $repeater->add_control(
            'jl_accordion_read_more_btn_url',
            [   
                'label'         => esc_html__( 'Button Link', 'wesper' ),
                'type'          => Controls_Manager::URL,
                'default'       => [
                    'url'           => '#',
                    'is_external'   => ''
                ],
                'show_external'     => true,
                'placeholder'       => __( 'http://your-link.com', 'wesper' ),
                'condition'     => [
                    '.jl_accordion_show_read_more_btn' => 'yes'
                ]
            ]
        );

        $repeater->end_controls_tab();

        $repeater->start_controls_tab('jl_accordion_item_image_tab', ['label' => __('Image', 'wesper')]);

        $repeater->add_control(
            'jl_accordion_image', [
                'label' => esc_html__( 'Choose Image', 'wesper' ),
                'type'  => Controls_Manager::MEDIA                
            ]
        );

        $repeater->end_controls_tab();

        $repeater->start_controls_tab('jl_accordion_item_style_tab', ['label' => __('Style', 'wesper')]);

        $repeater->add_control(
            'jl_accordion_each_item_container_style',
            [
                'label' => esc_html__( 'Container', 'wesper' ),
                'type'  => Controls_Manager::HEADING
            ]
        );

        $repeater->add_control(
            'jl_accordion_each_item_container_bg_color',
            [
                'label'     => __( 'Background Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.jl-accordion-single-item' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_control(
            'jl_accordion_each_item_title_style',
            [
                'label'     => esc_html__( 'Title', 'wesper' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $repeater->add_control(
            'jl_accordion_each_item_title_color',
            [
                'label'     => __( 'Text Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.jl-accordion-single-item .jl-accordion-title h3' => 'color: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_control(
            'jl_accordion_each_item_title_bg_color',
            [
                'label'     => __( 'Background Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.jl-accordion-single-item .jl-accordion-title' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_control(
            'jl_accordion_each_item_title_hover_color',
            [
                'label'     => __( 'Hover Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.jl-accordion-single-item .jl-accordion-title:hover h3' => 'color: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_control(
            'jl_accordion_each_item_title_hover_bg_color',
            [
                'label'     => __( 'Hover Background Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.jl-accordion-single-item .jl-accordion-title:hover' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $repeater->add_control(
            'jl_accordion_each_item_content_style',
            [
                'label'     => esc_html__( 'Content', 'wesper' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $repeater->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'jl_accordion_each_item_container_border',
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.jl-accordion-single-item'
            ]
        );

        $repeater->end_controls_tab();

        $repeater->end_controls_tabs();

        $this->add_control(
            'jl_accordion_tab',
            [
                'type'      => Controls_Manager::REPEATER,
                'fields'    => $repeater->get_controls(),
                'default'   => [
                    [ 
                        'jl_accordion_title'          => esc_html__( 'Accordion Title 1', 'wesper' ),
                        'jl_accordion_default_active' => 'yes'
                    ],
                    [ 'jl_accordion_title' => esc_html__( 'Accordion Title 2', 'wesper' ) ],
                    [ 'jl_accordion_title' => esc_html__( 'Accordion Title 3', 'wesper' ) ]
                ],
                'title_field' => '{{jl_accordion_title}}'
            ]
        );

        $this->end_controls_section();

        /**
         * -------------------------------------------
         * Tab Style Exclusive Accordion Container Style
         * -------------------------------------------
         */
        $this->start_controls_section(
            'jl_section_accordions_container_style',
            [
                'label' => esc_html__( 'Container', 'wesper' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );      

        $this->add_control(
            'jl_accordion_container_background_color',
            [
                'label'     => esc_html__( 'Background Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_container_padding',
            [
                'label'      => __('Padding', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_container_margin',
            [
                'label'        => __('Margin', 'wesper'),
                'type'         => Controls_Manager::DIMENSIONS,
                'size_units'   => ['px', '%'],
                'default'      => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'isLinked' => false
                ],
                'selectors'    => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'jl_accordion_container_border',
                'selector' => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item'
            ]
        );
        
        $this->add_responsive_control(
            'jl_accordion_container_border_radius',
            [
                'label'      => __('Border Radius', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
                    'top'    => '0',
                    'right'  => '0',
                    'bottom' => '0',
                    'left'   => '0'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'jl_accordion_container_box_shadow',
                'selector' => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'jl_section_accordions_tab_style',
            [
                'label' => esc_html__( 'Title', 'wesper' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'            => 'jl_accordion_title_typography',
                'selector'        => '{{WRAPPER}} .jl-accordion-single-item h3',
                'fields_options'  => [
                    'font_weight' => [
                        'default' => '600'
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_title_padding',
            [
                'label'      => __('Padding', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
                    'top'    => '20',
                    'right'  => '0',
                    'bottom' => '20',
                    'left'   => '0',
                    'isLinked' => false
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_title_margin',
            [
                'label'      => __('Margin', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
                    'top'    => '0',
                    'right'  => '0',
                    'bottom' => '0',
                    'left'   => '0'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'               => 'jl_accordion_title_border',
                'fields_options'       => [
                    'border'           => [
                        'default'      => 'solid'
                    ],
                    'width'            => [
                        'default'      => [
                            'top'      => '0',
                            'right'    => '0',
                            'bottom'   => '1',
                            'left'     => '0',
                            'isLinked' => false
                        ]
                    ],
                    'color'            => [
                        'default'      => '#E3E3E3'
                    ]
                ],
                'selector'           => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title'
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_title_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'jl_accordion_title_box_shadow',
                'selector' => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title'
            ]
        );

        $this->start_controls_tabs( 'jl_accordion_header_tabs' );

            # Normal State Tab
            $this->start_controls_tab( 'jl_accordion_header_normal', [ 'label' => esc_html__( 'Normal', 'wesper' ) ] );
                $this->add_control(
                    'jl_accordion_tab_text_color',
                    [
                        'label'     => esc_html__( 'Text Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'default'   => '#000000',
                        'selectors' => [
                            '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item h3, {{WRAPPER}} .jl-active-inactive-icon' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'jl_accordion_tab_color',
                    [
                        'label'     => esc_html__( 'Background Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );
                
            $this->end_controls_tab();

            #Hover State Tab
            $this->start_controls_tab( 'jl_accordion_header_hover', [ 'label' => esc_html__( 'Hover', 'wesper' ) ] );
                $this->add_control(
                    'jl_accordion_tab_text_color_hover',
                    [
                        'label'     => esc_html__( 'Text Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title:hover h3 , {{WRAPPER}} .jl-accordion-title:hover .jl-active-inactive-icon' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title.active:hover h3' => 'color: {{VALUE}};'
                        ]
                    ]
                );

                $this->add_control(
                    'jl_accordion_tab_color_bg_hover',
                    [
                        'label'     => esc_html__( 'Background Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title:hover' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();

            #Active State Tab
            $this->start_controls_tab( 'jl_accordion_header_active', [ 'label' => esc_html__( 'Active', 'wesper' ) ] );
                $this->add_control(
                    'jl_accordion_tab_text_color_active',
                    [
                        'label'     => esc_html__( 'Text Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title.active h3, {{WRAPPER}} .jl-accordion-title.active .jl-active-inactive-icon' => 'color: {{VALUE}} !important;'
                        ]
                    ]
                );

                $this->add_control(
                    'jl_accordion_tab_color_bg_active',
                    [
                        'label'     => esc_html__( 'Background Color', 'wesper' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title.active' => 'background-color: {{VALUE}};'
                        ]
                    ]
                );

            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'jl_accordion_tab_title_icon_style',
            [
                'label' => esc_html__( 'Title Icon', 'wesper' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_title_icon_size',
            [
                'label'        => __( 'Size', 'wesper' ),
                'type'         => Controls_Manager::SLIDER,
                'range'        => [
                    'px'       => [
                        'min'  => 10,
                        'max'  => 150,
                        'step' => 2
                    ]
                ],
                'default'      => [
                    'unit'     => 'px',
                    'size'     => 20
                ],
                'selectors'    => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title span.jl-tab-title-icon i' => 'font-size: {{SIZE}}{{UNIT}};'
                ]
            ]
        );   

        $this->add_responsive_control(
            'jl_accordion_title_icon_width',
            [
                'label'    => esc_html__( 'Width', 'wesper' ),
                'type'     => Controls_Manager::SLIDER,
                'default'  => [
                    'size' => 70
                ],
                'range'    => [
                    'px'   => [
                        'max' => 100
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title span.jl-tab-title-icon' => 'width: {{SIZE}}px;'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'jl_accordion_title_icon_border',
                'selector' => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title span.jl-tab-title-icon'
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_title_icon_padding',
            [
                'label'      => __('Padding', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title span.jl-tab-title-icon i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_title_icon_margin',
            [
                'label'      => __('Margin', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title span.jl-tab-title-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'jl_accordion_title_icon_style_tabs' );

            // normal state tab
            $this->start_controls_tab( 'jl_accordion_title_icon_general_style', [ 'label' => esc_html__( 'Normal', 'wesper' ) ] );

            $this->add_control(
                'jl_accordion_tab_title_icon_color',
                [
                    'label'     => esc_html__( 'Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title span.jl-tab-title-icon' => 'color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_control(
                'jl_accordion_tab_title_icon_bg_color',
                [
                    'label'     => esc_html__( 'Background Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title span.jl-tab-title-icon' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->end_controls_tab();

            // active state tab
            $this->start_controls_tab( 'jl_accordion_title_icon_active_style', [ 'label' => esc_html__( 'Active', 'wesper' ) ] );

            $this->add_control(
                'jl_accordion_title_icon_active_color',
                [
                    'label'     => esc_html__( 'Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title.active span.jl-tab-title-icon i' => 'color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_control(
                'jl_accordion_title_icon_active_bg_color',
                [
                    'label'     => esc_html__( 'Background Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-title.active span.jl-tab-title-icon' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->end_controls_section();

        $this->start_controls_section(
            'jl_accordion_active_inactive_icon_style',
            [
                'label'     => esc_html__( 'Active/Inactive Icon', 'wesper' ),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_active_inactive_icon_size',
            [
                'label'        => esc_html__( 'Size', 'wesper' ),
                'type'         => Controls_Manager::SLIDER,
                'range'        => [
                    'px'       => [
                        'min'  => 10,
                        'max'  => 150,
                        'step' => 2
                    ]
                ],
                'default'      => [
                    'unit'     => 'px',
                    'size'     => 26
                ],
                'selectors'    => [
                    '{{WRAPPER}} .jl-active-inactive-icon' => 'font-size: {{SIZE}}px;'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_active_inactive_icon_width',
            [
                'label'       => esc_html__( 'Right Space', 'wesper' ),
                'type'        => Controls_Manager::SLIDER,
                'default'     => [
                    'size'    => 0
                ],
                'range'       => [
                    'px'      => [
                        'max' => 100
                    ]
                ],
                'selectors'   => [
                    '{{WRAPPER}} .jl-active-inactive-icon' => 'margin-right: {{SIZE}}px;'
                ]
            ]
        );

        $this->end_controls_section();
        
        /**
         * -------------------------------------------
         * Tab Style Exclusive Accordion Content Style
         * -------------------------------------------
         */

        $this->start_controls_section(
            'jl_section_accordion_tab_content_style_settings',
            [
                'label' => esc_html__( 'Content', 'wesper' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'jl_accordion_content_typography',
                'selector' => '{{WRAPPER}} .jl-accordion-single-item .jl-accordion-text'
            ]
        );

        $this->add_control(
            'jl_accordion_content_bg_color',
            [
                'label'     => esc_html__( 'Background Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-content .jl-accordion-content-wrapper' => 'background-color: {{VALUE}};'
                ]
            ]
        );

        $this->add_control(
            'jl_accordion_content_text_color',
            [
                'label'     => esc_html__( 'Text Color', 'wesper' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .jl-accordion-single-item .jl-accordion-text' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_content_padding',
            [
                'label'      => __('Padding', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
                    'top'    => '20',
                    'right'  => '0',
                    'bottom' => '20',
                    'left'   => '0'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-content .jl-accordion-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_content_margin',
            [
                'label'      => __('Margin', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
                    'top'    => '0',
                    'right'  => '0',
                    'bottom' => '0',
                    'left'   => '0'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-single-item .jl-accordion-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'                 => 'jl_accordion_content_border',
                'fields_options'       => [
                    'border'           => [
                        'default'      => 'solid'
                    ],
                    'width'            => [
                        'default'      => [
                            'top'      => '0',
                            'right'    => '0',
                            'bottom'   => '1',
                            'left'     => '0',
                            'isLinked' => false
                        ]
                    ],
                    'color'            => [
                        'default'      => '#E3E3E3'
                    ]
                ],
                'selector'             => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-content .jl-accordion-content-wrapper'
            ]
        );
        
        $this->add_responsive_control(
            'jl_accordion_content_border_radius',
            [
                'label'      => __('Border Radius', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
                    'top'    => '0',
                    'right'  => '0',
                    'bottom' => '0',
                    'left'   => '0'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-content .jl-accordion-content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->end_controls_section();

       
       
       
       
       
       
       
       
       
        $this->start_controls_section(
            'jl_section_accordion_tab_image_style',
            [
                'label' => esc_html__( 'Image', 'wesper' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE

            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'jl_accordion_image_size',
                'label'   => esc_html__( 'Image Type', 'wesper' ),
                'default' => 'medium'
            ]
        );

        $this->add_control(
            'jl_accordion_image_align',
            [
                'label'         => esc_html__( 'Image Position', 'wesper' ),
                'type'          => Controls_Manager::CHOOSE,
                'toggle'        => false,
                'options'       => [
                    'left'      => [
                        'title' => esc_html__( 'Left', 'wesper' ),
                        'icon'  => 'eicon-angle-left'
                    ],
                    'right'     => [
                        'title' => esc_html__( 'Right', 'wesper' ),
                        'icon'  => 'eicon-angle-right'
                    ]
                ],
                'default'       => 'right'
            ]
        );        

        $this->add_responsive_control(
            'jl_accordion_image_padding',
            [
                'label'      => __('Padding', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
                    'top'    => '20',
                    'right'  => '20',
                    'bottom' => '20',
                    'left'   => '20'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_image_margin',
            [
                'label'      => __('Margin', 'wesper'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        
        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'jl_accordion_image_css_filter',
                'selector' => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-image img',
            ]
        );

        $this->end_controls_section();





        
        $this->start_controls_section(
            'jl_accordion_details_btn_style_section',
            [
                'label' => esc_html__( 'Button', 'wesper' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'jl_accordion_details_btn_typography',
                'selector' => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a'
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_details_btn_padding',
            [
                'label'      => esc_html__( 'Padding', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,           
                'size_units' => [ 'px', 'em', '%' ],
                'default'    => [
                    'top'    => '15',
                    'right'  => '40',
                    'bottom' => '15',
                    'left'   => '40'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'jl_accordion_details_btn_margin',
            [
                'label'      => esc_html__( 'Margin', 'wesper' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],   
                'default'    => [
                    'top'    => '30',
                    'right'  => '0',
                    'bottom' => '0',
                    'left'   => '0'
                ],              
                'selectors'  => [
                    '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'jl_accordion_details_button_style_tabs' );

            // normal state tab
            $this->start_controls_tab( 'jl_accordion_details_btn_normal', [ 'label' => esc_html__( 'Normal', 'wesper' ) ] );

            $this->add_control(
                'jl_accordion_details_btn_normal_text_color',
                [
                    'label'     => esc_html__( 'Text Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a' => 'color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_control(
                'jl_accordion_details_btn_normal_bg_color',
                [
                    'label'     => esc_html__( 'Background Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#000000',
                    'selectors' => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'               => 'jl_accordion_details_btn_border',
                    'fields_options'     => [
                        'border'         => [
                            'default'    => 'solid'
                        ],
                        'width'          => [
                            'default'    => [
                                'top'    => '1',
                                'right'  => '1',
                                'bottom' => '1',
                                'left'   => '1'
                            ]
                        ],
                        'color'          => [
                            'default'    => '#E3E3E3'
                        ]
                    ],
                    'selector'           => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a'
                ]
            );

            $this->add_responsive_control(
                'jl_accordion_details_button_border_radius',
                [
                    'label'      => esc_html__( 'Border Radius', 'wesper' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'selectors'  => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'      => 'jl_accordion_details_button_shadow',
                    'selector'  => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a'
                ]
            );

            $this->end_controls_tab();

            // hover state tab
            $this->start_controls_tab( 'jl_accordion_details_btn_hover', [ 'label' => esc_html__( 'Hover', 'wesper' ) ] );

            $this->add_control(
                'jl_accordion_details_btn_hover_text_color',
                [
                    'label'     => esc_html__( 'Text Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#000000',
                    'selectors' => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a:hover' => 'color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_control(
                'jl_accordion_details_btn_hover_bg_color',
                [
                    'label'     => esc_html__( 'Background Color', 'wesper' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a:hover' => 'background-color: {{VALUE}};'
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'     => 'jl_accordion_details_btn_hover_border',
                    'selector' => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a:hover'
                ]
            );

            $this->add_responsive_control(
                'jl_accordion_details_button_border_radius_hover',
                [
                    'label'      => esc_html__( 'Border Radius', 'wesper' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px'],
                    'selectors'  => [
                        '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a:hover'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'      => 'jl_accordion_details_button_hover_shadow',
                    'selector'  => '{{WRAPPER}} .jl-accordion-items .jl-accordion-single-item .jl-accordion-button a:hover'
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section(); 
                
    }

    private function jl_render_image( $accordion, $settings ) {
        $image_id   = $accordion['jl_accordion_image']['id'];
        $image_size = $settings['jl_accordion_image_size_size'];
        if ( 'custom' === $image_size ) {
            $image_src = Group_Control_Image_Size::get_attachment_image_src( $image_id, 'jl_accordion_image_size', $settings );
        } else {
            $image_src = wp_get_attachment_image_src( $image_id, $image_size );
            $image_src = $image_src[0];
        }

        return sprintf( '<img src="%s" alt="'.Control_Media::get_image_alt( $accordion['jl_accordion_image'] ).'" />', esc_url($image_src) );
    }

    protected function render( ) {
    $settings   = $this->get_settings_for_display();
        
        $this->add_render_attribute( 'jl_accordion_heading', 'class', 'jl-accordion-heading' );
        $this->add_render_attribute( 'jl_accordion_details', 'class', 'jl-accordion-text' );
        $this->add_render_attribute( 'jl_accordion_button', 'class', 'jl-accordion-button' );

        ?>
    
        <div class="jl-accordion-items">
            <?php
            foreach( $settings['jl_accordion_tab'] as $key => $accordion ) :
                
                $accordion_item_setting_key = $this->get_repeater_setting_key('jl_accordion_title', 'jl_accordion_tab', $key);

                $accordion_class = ['jl-accordion-title'];

                if ( $accordion['jl_accordion_default_active'] === 'yes' ) {
                    $accordion_class[] = 'active-default';
                } 

                $this->add_render_attribute( $accordion_item_setting_key, 'class', $accordion_class );

                $has_image = !empty( $accordion['jl_accordion_image']['url'] ) ? 'yes' : 'no';
                $link_key  = 'link_' . $key;

                ?>

                <div class="jl-accordion-single-item elementor-repeater-item-<?php echo esc_attr($accordion['_id']); ?>">
                    <div <?php echo $this->get_render_attribute_string($accordion_item_setting_key); ?>>

                        <?php if ( ! empty( $accordion['jl_accordion_title_icon']['value'] ) && 'yes' === $accordion['jl_accordion_icon_show'] ) : ?>
                            <span class="jl-tab-title-icon">
                                <?php Icons_Manager::render_icon( $accordion['jl_accordion_title_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </span>
                        <?php endif; ?>

                        <h3 <?php echo $this->get_render_attribute_string( 'jl_accordion_heading' ); ?>><?php echo $accordion['jl_accordion_title']; ?></h3>                        
                            <div class="jl-active-inactive-icon">                                
                                    <span class="jl-active-icon">-</span>
                                    <span class="jl-inactive-icon">+</span>                                
                            </div>                        
                    </div>

                    <div class="jl-accordion-content">
                        <div class="jl-accordion-content-wrapper has-image-<?php echo esc_attr($has_image); ?> image-position-<?php echo esc_attr( $settings['jl_accordion_image_align'] ); ?>">
                            <div <?php echo $this->get_render_attribute_string( 'jl_accordion_details' ); ?>>
                                <div> <?php echo wp_kses_post( $accordion['jl_accordion_content'] ); ?></div>
                                <?php if( 'yes' === $accordion['jl_accordion_show_read_more_btn'] ) : ?>
                                    <?php if( $accordion['jl_accordion_read_more_btn_url']['url'] ) { ?>
                                        <?php $this->add_render_attribute( $link_key, 'href', esc_url( $accordion['jl_accordion_read_more_btn_url']['url'] ) ); ?>
                                        <?php if( $accordion['jl_accordion_read_more_btn_url']['is_external'] ) { ?>
                                            <?php $this->add_render_attribute( $link_key, 'target', '_blank' ); ?>
                                        <?php } ?>
                                        <?php if( $accordion['jl_accordion_read_more_btn_url']['nofollow'] ) { ?>
                                            <?php $this->add_render_attribute( $link_key, 'rel', 'nofollow' ); ?>
                                        <?php } ?>
                                    <?php } ?>
                                    <?php if ( ! empty( $accordion['jl_accordion_read_more_btn_text'] ) ) : ?>
                                        <div <?php echo $this->get_render_attribute_string( 'jl_accordion_button' ); ?>>
                                            <a <?php echo $this->get_render_attribute_string( $link_key ); ?>>
                                                <?php echo esc_html( $accordion['jl_accordion_read_more_btn_text'] ); ?>
                                            </a>
                                        </div> 
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>

                            <?php if ( ! empty( $accordion['jl_accordion_image']['url'] ) ) { ?>
                                <div class="jl-accordion-image">
                                    <?php echo $this->jl_render_image( $accordion, $settings ); ?>
                                </div>
                            <?php } ?>

                        </div>
                    </div>
                </div>                
            <?php endforeach; ?>            
        </div>
    <?php
}
}